/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.preview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.support.annotation.NonNull;
import com.eaglesakura.android.camera.spec.CaptureSize;
import com.eaglesakura.android.device.egl.EGLSpecRequest;
import com.eaglesakura.android.device.egl.GLESVersion;
import com.eaglesakura.android.device.egl.IEGLDevice;
import com.eaglesakura.android.device.egl.egl11.EGL11Manager;

@TargetApi(value=14)
public class OffscreenPreviewSurface {
    @NonNull
    private final Context mContext;
    private EGL11Manager mEglManager;
    private IEGLDevice mEglDevice;
    private SurfaceTexture mSurface;
    private int mPreviewTexture;
    @NonNull
    private final CaptureSize mCaptureSize;

    public OffscreenPreviewSurface(@NonNull Context context, @NonNull CaptureSize captureSize) {
        this.mContext = context;
        this.mCaptureSize = captureSize;
    }

    private int getRequestPreviewWidth() {
        return this.mCaptureSize.getWidth();
    }

    private int getRequestPreviewHeight() {
        return this.mCaptureSize.getHeight();
    }

    private SurfaceTexture createSurfaceTexture() {
        this.mEglManager = new EGL11Manager(this.mContext);
        EGLSpecRequest eglSpecRequest = new EGLSpecRequest();
        eglSpecRequest.version = GLESVersion.GLES11;
        eglSpecRequest.surfaceColor = null;
        eglSpecRequest.surfaceDepthBits = 0;
        eglSpecRequest.surfaceStencilBits = 0;
        this.mEglManager.initialize(eglSpecRequest);
        this.mEglDevice = this.mEglManager.newDevice(null);
        this.mEglDevice.createPBufferSurface(this.getRequestPreviewWidth(), this.getRequestPreviewHeight());
        if (!this.mEglDevice.bind()) {
            throw new IllegalStateException("EGL createSurface failed");
        }
        this.mPreviewTexture = OffscreenPreviewSurface.genPreviewTexture();
        this.mSurface = new SurfaceTexture(this.mPreviewTexture);
        if (Build.VERSION.SDK_INT >= 15) {
            this.mSurface.setDefaultBufferSize(this.getRequestPreviewWidth(), this.getRequestPreviewHeight());
        }
        return this.mSurface;
    }

    public SurfaceTexture createSurface() {
        if (this.mSurface != null) {
            return this.mSurface;
        }
        return this.createSurfaceTexture();
    }

    private static int genPreviewTexture() {
        int[] temp = new int[1];
        GLES20.glGenTextures((int)1, (int[])temp, (int)0);
        int texture = temp[0];
        return texture;
    }

    public void dispose() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (this.mPreviewTexture != 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mPreviewTexture}, (int)0);
            this.mPreviewTexture = 0;
        }
        if (this.mEglDevice != null) {
            this.mEglDevice.unbind();
            this.mEglDevice.dispose();
            this.mEglDevice = null;
        }
    }
}

