/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.eaglesakura.android.camera.CameraApi;
import com.eaglesakura.android.camera.CameraConnectRequest;
import com.eaglesakura.android.camera.CameraControlManager;
import com.eaglesakura.android.camera.CameraEnvironmentRequest;
import com.eaglesakura.android.camera.CameraLegacySpecImpl;
import com.eaglesakura.android.camera.CameraPictureShotRequest;
import com.eaglesakura.android.camera.CameraPreviewRequest;
import com.eaglesakura.android.camera.LegacyCameraControlManager$$Lambda$1;
import com.eaglesakura.android.camera.LegacyCameraControlManager$$Lambda$4;
import com.eaglesakura.android.camera.PictureData;
import com.eaglesakura.android.camera.error.CameraAccessFailedException;
import com.eaglesakura.android.camera.error.CameraException;
import com.eaglesakura.android.camera.log.CameraLog;
import com.eaglesakura.android.camera.preview.CameraSurface;
import com.eaglesakura.android.camera.spec.CaptureSize;
import com.eaglesakura.android.util.ContextUtil;
import com.eaglesakura.thread.Holder;
import com.eaglesakura.util.Timer;
import java.io.IOException;

public class LegacyCameraControlManager
extends CameraControlManager {
    CameraSurface mPreviewSurface;
    CameraPreviewRequest mPreviewRequest;
    CameraPictureShotRequest mPictureShotRequest;
    Camera mCamera;
    Camera.Parameters mParameters;
    Camera.CameraInfo mCameraInfo = new Camera.CameraInfo();
    private static final int FLAG_NOW_PREVIEW = 1;
    int mFlags = 0;
    final Object lock = new Object();

    LegacyCameraControlManager(Context context, CameraConnectRequest request) {
        super(context, request);
    }

    @Override
    @NonNull
    public CameraApi getSupportApi() {
        return CameraApi.Legacy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(@Nullable CameraSurface previewSurface, @Nullable CameraPreviewRequest previewRequest, @Nullable CameraPictureShotRequest shotRequest) throws CameraException {
        Object object = this.lock;
        synchronized (object) {
            this.mPreviewRequest = previewRequest;
            this.mPreviewSurface = previewSurface;
            this.mPictureShotRequest = shotRequest;
            int number = CameraLegacySpecImpl.getCameraNumber(this.mConnectRequest.getCameraType());
            Camera.getCameraInfo((int)number, (Camera.CameraInfo)this.mCameraInfo);
            this.mCamera = Camera.open((int)number);
            this.mParameters = this.mCamera.getParameters();
            this.mFlags |= 1;
        }
        return true;
    }

    @Override
    public boolean isPreviewNow() {
        return (this.mFlags & 1) != 0;
    }

    @Override
    public boolean isConnected() {
        return this.mCamera != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isConnected()) {
                throw new IllegalStateException("not connected");
            }
            if (this.isPreviewNow()) {
                try {
                    this.stopPreviewImpl();
                }
                catch (CameraException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.mCamera.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mCamera = null;
        }
    }

    private void commitCameraParams() {
        try {
            this.mCamera.setParameters(this.mParameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mParameters = this.mCamera.getParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void requestPreviewRotateLinkDevice() {
        int deviceRotateDegree = ContextUtil.getDeviceRotateDegree((Context)this.mContext);
        if (this.mCameraInfo.facing == 1) {
            deviceRotateDegree = (this.mCameraInfo.orientation + deviceRotateDegree) % 360;
            deviceRotateDegree = (360 - deviceRotateDegree) % 360;
        } else {
            deviceRotateDegree = (this.mCameraInfo.orientation - deviceRotateDegree + 360) % 360;
        }
        this.mParameters.setRotation((deviceRotateDegree + 180) % 360);
        this.commitCameraParams();
        this.mCamera.setDisplayOrientation(deviceRotateDegree);
    }

    private void updateEnvironment(CameraEnvironmentRequest env) throws CameraException {
        if (env.getWhiteBalance() != null) {
            this.mParameters.setWhiteBalance(env.getWhiteBalance().getRawName());
            this.commitCameraParams();
        }
        if (env.getScene() != null) {
            this.mParameters.setSceneMode(env.getScene().getRawName());
            this.commitCameraParams();
        }
        if (env.getFocusMode() != null) {
            this.mParameters.setFocusMode(env.getFocusMode().getRawName());
            this.commitCameraParams();
        }
        if (env.getFlashMode() != null) {
            this.mParameters.setFlashMode(env.getFlashMode().getRawName());
            this.commitCameraParams();
        }
    }

    private void startCameraPreview() throws CameraException {
        SurfaceTexture surface = this.mPreviewSurface.getSurfaceTexture(this.mPreviewRequest.getPreviewSize());
        try {
            this.mCamera.setPreviewTexture(surface);
            this.mCamera.startPreview();
        }
        catch (IOException e) {
            throw new CameraAccessFailedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaptureSize getRawPreviewSize() {
        Object object = this.lock;
        synchronized (object) {
            Camera.Size size = this.mParameters.getPreviewSize();
            return new CaptureSize(size.width, size.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPreview(@Nullable CameraEnvironmentRequest env) throws CameraException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isConnected()) {
                throw new IllegalStateException("not connected");
            }
            this.mParameters.setPreviewSize(this.mPreviewRequest.getPreviewSize().getWidth(), this.mPreviewRequest.getPreviewSize().getHeight());
            this.commitCameraParams();
            this.requestPreviewRotateLinkDevice();
            this.updateEnvironment(env);
            this.startCameraPreview();
        }
    }

    private void stopPreviewImpl() throws CameraException {
        try {
            this.mCamera.stopPreview();
            this.mCamera.setPreviewCallback(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mFlags &= 0xFFFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPreview() throws CameraException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isPreviewNow()) {
                throw new IllegalStateException();
            }
            this.stopPreviewImpl();
        }
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public void startAutoFocus() {
        try {
            this.mCamera.cancelAutoFocus();
            this.mCamera.autoFocus(null);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            CameraLog.hardware("AutoFocus failed", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestAutoFocus() {
        boolean bl;
        Timer timer = new Timer();
        try {
            Holder resultHolder = new Holder();
            this.mCamera.cancelAutoFocus();
            this.mCamera.autoFocus(LegacyCameraControlManager$$Lambda$1.lambdaFactory$(resultHolder));
            bl = (Boolean)resultHolder.getWithWait(3000L);
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                CameraLog.hardware("AutoFocus %d ms", timer.end());
                throw throwable;
            }
            CameraLog.hardware("AutoFocus %d ms", timer.end());
            return bl2;
        }
        CameraLog.hardware("AutoFocus %d ms", timer.end());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public PictureData takePicture(@Nullable CameraEnvironmentRequest env) throws CameraException {
        if (!this.isConnected() || !this.isPreviewNow()) {
            throw new IllegalStateException("Preview not start");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                PictureData data;
                this.requestAutoFocus();
                if (this.mPictureShotRequest.hasLocation()) {
                    this.mParameters.setGpsLatitude(this.mPictureShotRequest.getLatitude());
                    this.mParameters.setGpsLongitude(this.mPictureShotRequest.getLongitude());
                    this.commitCameraParams();
                }
                this.mParameters.setJpegQuality(100);
                this.commitCameraParams();
                this.mParameters.setPreviewSize(this.mPreviewRequest.getPreviewSize().getWidth(), this.mPreviewRequest.getPreviewSize().getHeight());
                this.commitCameraParams();
                this.mParameters.setPictureSize(this.mPictureShotRequest.getCaptureSize().getWidth(), this.mPictureShotRequest.getCaptureSize().getHeight());
                this.commitCameraParams();
                this.updateEnvironment(env);
                Holder jpegBuffer = new Holder();
                this.mCamera.takePicture(null, null, LegacyCameraControlManager$$Lambda$4.lambdaFactory$(jpegBuffer));
                PictureData pictureData = data = new PictureData(this.mPictureShotRequest.getCaptureSize().getWidth(), this.mPictureShotRequest.getCaptureSize().getHeight(), (byte[])jpegBuffer.getWithWait(3000L));
                return pictureData;
            }
        }
        finally {
            this.startPreview(env);
        }
    }

    static /* synthetic */ void lambda$takePicture$14(Holder holder, byte[] data, Camera camera) {
        holder.set((Object)data);
    }

    static /* synthetic */ void lambda$requestAutoFocus$13(Holder holder, boolean success, Camera camera) {
        holder.set((Object)success);
    }
}

