/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.eaglesakura.android.camera.Camera2ControlManager;
import com.eaglesakura.android.camera.CameraApi;
import com.eaglesakura.android.camera.CameraConnectRequest;
import com.eaglesakura.android.camera.CameraEnvironmentRequest;
import com.eaglesakura.android.camera.CameraPictureShotRequest;
import com.eaglesakura.android.camera.CameraPreviewRequest;
import com.eaglesakura.android.camera.LegacyCameraControlManager;
import com.eaglesakura.android.camera.PictureData;
import com.eaglesakura.android.camera.error.CameraException;
import com.eaglesakura.android.camera.preview.CameraSurface;

public abstract class CameraControlManager {
    protected final Context mContext;
    protected final CameraConnectRequest mConnectRequest;

    public CameraControlManager(Context context, CameraConnectRequest request) {
        this.mContext = context.getApplicationContext();
        this.mConnectRequest = request;
    }

    @NonNull
    public abstract CameraApi getSupportApi();

    public abstract boolean connect(@Nullable CameraSurface var1, @Nullable CameraPreviewRequest var2, @Nullable CameraPictureShotRequest var3) throws CameraException;

    public abstract boolean isPreviewNow();

    public abstract boolean isConnected();

    public abstract void disconnect();

    public abstract void startPreview(@Nullable CameraEnvironmentRequest var1) throws CameraException;

    public abstract void stopPreview() throws CameraException;

    @NonNull
    public abstract PictureData takePicture(@Nullable CameraEnvironmentRequest var1) throws CameraException;

    public static CameraControlManager newInstance(Context context, CameraApi api, CameraConnectRequest request) throws CameraException {
        if (api.equals((Object)CameraApi.Default)) {
            api = Build.VERSION.SDK_INT >= 21 ? CameraApi.Camera2 : CameraApi.Legacy;
        }
        if (api == CameraApi.Camera2) {
            return new Camera2ControlManager(context, request);
        }
        return new LegacyCameraControlManager(context, request);
    }

    public static CameraControlManager newInstance(Context context, CameraConnectRequest request) throws CameraException {
        return CameraControlManager.newInstance(context, CameraApi.Default, request);
    }
}

