/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.support.annotation.NonNull;
import com.eaglesakura.android.camera.CameraSpec;
import com.eaglesakura.android.camera.error.CameraAccessFailedException;
import com.eaglesakura.android.camera.error.CameraException;
import com.eaglesakura.android.camera.error.CameraNotFoundException;
import com.eaglesakura.android.camera.spec.CameraType;
import com.eaglesakura.android.camera.spec.CaptureFormat;
import com.eaglesakura.android.camera.spec.CaptureSize;
import com.eaglesakura.android.camera.spec.FlashMode;
import com.eaglesakura.android.camera.spec.FocusMode;
import com.eaglesakura.android.camera.spec.Scene;
import com.eaglesakura.android.camera.spec.WhiteBalance;
import com.eaglesakura.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"NewApi"})
public class Camera2SpecImpl {
    private static final Map<CaptureFormat, Integer> sCaptureFormatMap = new HashMap<CaptureFormat, Integer>();
    private static final Map<FlashMode, Integer> sFlashModeMap = new HashMap<FlashMode, Integer>();
    private static final Map<FocusMode, Integer> sFocusModeMap = new HashMap<FocusMode, Integer>();
    private static final Map<Scene, Integer> sSceneModeMap = new HashMap<Scene, Integer>();
    private static final Map<WhiteBalance, Integer> sWhiteBalanceMap = new HashMap<WhiteBalance, Integer>();
    private Context mContext;
    private CameraManager mCameraManager;
    private String mCameraId;

    Camera2SpecImpl(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            throw new IllegalStateException();
        }
        this.mContext = context.getApplicationContext();
        this.mCameraManager = (CameraManager)this.mContext.getSystemService("camera");
    }

    CameraManager getCameraManager() {
        return this.mCameraManager;
    }

    String getCameraId() {
        return this.mCameraId;
    }

    CameraCharacteristics getCameraSpec(CameraType type) throws CameraException {
        try {
            String autoCameraId = null;
            CameraCharacteristics autoCharacteristics = null;
            for (String id : this.mCameraManager.getCameraIdList()) {
                CameraCharacteristics characteristics = this.mCameraManager.getCameraCharacteristics(id);
                int facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (facing == 0) {
                    if (type == CameraType.Front) {
                        this.mCameraId = id;
                        return characteristics;
                    }
                    if (autoCameraId != null) continue;
                    autoCameraId = id;
                    autoCharacteristics = characteristics;
                    continue;
                }
                if (facing == 1) {
                    if (type == CameraType.Back) {
                        this.mCameraId = id;
                        return characteristics;
                    }
                    autoCameraId = id;
                    autoCharacteristics = characteristics;
                    continue;
                }
                if (facing != 2) continue;
                if (type == CameraType.External) {
                    this.mCameraId = id;
                    return characteristics;
                }
                if (autoCameraId != null) continue;
                autoCameraId = id;
                autoCharacteristics = characteristics;
            }
            if (autoCameraId != null) {
                this.mCameraId = autoCameraId;
                return autoCharacteristics;
            }
            throw new CameraNotFoundException("type :: " + (Object)((Object)type));
        }
        catch (CameraAccessException e) {
            throw new CameraAccessFailedException(e);
        }
    }

    @NonNull
    List<FlashMode> getFlashModes(CameraCharacteristics characteristics) throws CameraException {
        if (!((Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE)).booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<FlashMode> result = new ArrayList<FlashMode>();
        for (int mode : (int[])characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES)) {
            FlashMode keyFromValue = (FlashMode)CollectionUtil.findKeyFromValue(sFlashModeMap, (Object)mode);
            if (keyFromValue == null) continue;
            result.add(keyFromValue);
        }
        return result;
    }

    @NonNull
    List<FocusMode> getFocusModes(CameraCharacteristics characteristics) throws CameraException {
        ArrayList<FocusMode> result = new ArrayList<FocusMode>();
        for (int mode : (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
            FocusMode value = (FocusMode)CollectionUtil.findKeyFromValue(sFocusModeMap, (Object)mode);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @NonNull
    List<CaptureSize> getPictureSizes(CameraCharacteristics characteristics, CaptureFormat format) throws CameraException {
        Object[] sizes = ((StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(Camera2SpecImpl.toImageFormatInt(format));
        if (CollectionUtil.isEmpty((Object[])sizes)) {
            return new ArrayList<CaptureSize>();
        }
        ArrayList<CaptureSize> result = new ArrayList<CaptureSize>();
        for (Object size : sizes) {
            result.add(new CaptureSize(size.getWidth(), size.getHeight()));
        }
        return result;
    }

    @NonNull
    List<CaptureSize> getPreviewSizes(CameraCharacteristics characteristics) throws CameraException {
        Object[] sizes = ((StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(SurfaceTexture.class);
        if (CollectionUtil.isEmpty((Object[])sizes)) {
            throw new CameraAccessFailedException("size error");
        }
        ArrayList<CaptureSize> result = new ArrayList<CaptureSize>();
        for (Object size : sizes) {
            result.add(new CaptureSize(size.getWidth(), size.getHeight()));
        }
        return result;
    }

    @NonNull
    List<Scene> getScenes(CameraCharacteristics characteristics) throws CameraException {
        ArrayList<Scene> result = new ArrayList<Scene>();
        for (int mode : (int[])characteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_SCENE_MODES)) {
            Scene value = (Scene)CollectionUtil.findKeyFromValue(sSceneModeMap, (Object)mode);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @NonNull
    List<WhiteBalance> getWhiteBalances(CameraCharacteristics characteristics) throws CameraException {
        ArrayList<WhiteBalance> result = new ArrayList<WhiteBalance>();
        for (int mode : (int[])characteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES)) {
            WhiteBalance value = (WhiteBalance)CollectionUtil.findKeyFromValue(sWhiteBalanceMap, (Object)mode);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    static CameraSpec getSpecs(Context context, CameraType type) throws CameraException {
        CameraSpec result = new CameraSpec(type);
        Camera2SpecImpl impl = new Camera2SpecImpl(context);
        CameraCharacteristics spec = impl.getCameraSpec(type);
        result.mFlashModeSpecs = impl.getFlashModes(spec);
        result.mFocusModeSpecs = impl.getFocusModes(spec);
        result.mJpegPictureSize = impl.getPictureSizes(spec, CaptureFormat.Jpeg);
        result.mRawPictureSize = impl.getPictureSizes(spec, CaptureFormat.Raw);
        result.mPreviewSizes = impl.getPreviewSizes(spec);
        result.mSceneSpecs = impl.getScenes(spec);
        result.mWhiteBalanceSpecs = impl.getWhiteBalances(spec);
        return result.init();
    }

    static int toSceneInt(Scene scene) {
        return sSceneModeMap.get(scene);
    }

    static int toAeModeInt(FocusMode mode) {
        return sFocusModeMap.get(mode);
    }

    static int toAwbInt(WhiteBalance mode) {
        return sWhiteBalanceMap.get(mode);
    }

    static int toFlashModeInt(FlashMode mode) {
        return sFlashModeMap.get(mode);
    }

    static int toImageFormatInt(CaptureFormat format) {
        return sCaptureFormatMap.get((Object)format);
    }

    static {
        sCaptureFormatMap.put(CaptureFormat.Jpeg, 256);
        sCaptureFormatMap.put(CaptureFormat.Raw, 32);
        sFlashModeMap.put(FlashMode.SETTING_OFF, 0);
        sFlashModeMap.put(FlashMode.SETTING_ON, 1);
        sFlashModeMap.put(FlashMode.SETTING_TORCH, 3);
        sFlashModeMap.put(FlashMode.SETTING_RED_EYE, 4);
        sFlashModeMap.put(FlashMode.SETTING_AUTO, 2);
        sFocusModeMap.put(FocusMode.SETTING_AUTO, 1);
        sFocusModeMap.put(FocusMode.SETTING_CONTINUOUS_PICTURE, 4);
        sFocusModeMap.put(FocusMode.SETTING_CONTINUOUS_VIDEO, 3);
        sFocusModeMap.put(FocusMode.SETTING_MACRO, 2);
        sFocusModeMap.put(FocusMode.SETTING_INFINITY, 0);
        sSceneModeMap.put(Scene.SETTING_AUTO, 1);
        sSceneModeMap.put(Scene.SETTING_PORTRAIT, 3);
        sSceneModeMap.put(Scene.SETTING_LANDSCAPE, 4);
        sSceneModeMap.put(Scene.SETTING_NIGHT, 5);
        sSceneModeMap.put(Scene.SETTING_NIGHT_PORTRAIT, 6);
        sSceneModeMap.put(Scene.SETTING_BEACH, 8);
        sSceneModeMap.put(Scene.SETTING_SNOW, 9);
        sSceneModeMap.put(Scene.SETTING_SPORTS, 13);
        sSceneModeMap.put(Scene.SETTING_PARTY, 14);
        sSceneModeMap.put(Scene.SETTING_DOCUMENT, 16);
        sWhiteBalanceMap.put(WhiteBalance.SETTING_AUTO, 1);
        sWhiteBalanceMap.put(WhiteBalance.SETTING_INCANDESCENT, 2);
        sWhiteBalanceMap.put(WhiteBalance.SETTING_FLUORESCENT, 3);
        sWhiteBalanceMap.put(WhiteBalance.SETTING_DAYLIGHT, 5);
        sWhiteBalanceMap.put(WhiteBalance.SETTING_CLOUDY_DAYLIGHT, 6);
    }
}

