/*
 * Decompiled with CFR 0.152.
 */
package com.ea.async.instrumentation;

import com.ea.async.shaded.net.bytebuddy.agent.ByteBuddyAgent;
import com.ea.async.shaded.org.objectweb.asm.ClassVisitor;
import com.ea.async.shaded.org.objectweb.asm.tree.ClassNode;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.Analyzer;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;

public class InitializeAsync {
    static final String EA_ASYNC_RUNNING = "ea-async.running";
    static boolean isRunning = "true".equals(System.getProperty("ea-async.running", "false"));

    static URL getClassPathFor(Class<?> clazz) throws URISyntaxException, MalformedURLException {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        try {
            URL url = InitializeAsync.getClassFile(clazz);
            String urlString = url.toString();
            int endIndex = urlString.indexOf("!");
            if (endIndex > 0) {
                int beginIndex = urlString.toLowerCase(Locale.ENGLISH).lastIndexOf("file:/");
                if (beginIndex >= 0) {
                    return new URL(urlString.substring(beginIndex, endIndex));
                }
                beginIndex = urlString.lastIndexOf("[a-zA-Z]+://");
                if (beginIndex > 0) {
                    return new URL(urlString.substring(beginIndex, endIndex));
                }
            } else {
                File dir = new File(url.toURI()).getParentFile();
                if (clazz.getPackage() != null) {
                    String pn = clazz.getPackage().getName();
                    int i = pn.indexOf(46);
                    while (i >= 0) {
                        dir = dir.getParentFile();
                        i = pn.indexOf(46, i + 1);
                    }
                    dir = dir.getParentFile();
                }
                return dir.toURI().toURL();
            }
            throw new RuntimeException("Error locating classpath entry for: " + clazz.getName() + " url: " + url);
        }
        catch (Exception e) {
            throw new RuntimeException("Error locating classpath entry for: " + clazz.getName(), e);
        }
    }

    private static URL getClassFile(Class<?> clazz) {
        int idx = clazz.getName().lastIndexOf(46);
        String fileName = (idx >= 0 ? clazz.getName().substring(idx + 1) : clazz.getName()) + ".class";
        return clazz.getResource(fileName);
    }

    static void loadAgent() {
        String jarName = null;
        try {
            String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
            int p = nameOfRunningVM.indexOf(64);
            String pid = nameOfRunningVM.substring(0, p);
            URL url = InitializeAsync.getClassPathFor(InitializeAsync.class);
            File classPathFile = new File(url.toURI());
            if (classPathFile.isFile()) {
                jarName = classPathFile.getPath();
            } else {
                File jarFile = new File(InitializeAsync.class.getResource("async-stub.jar").toURI());
                jarName = jarFile.getPath();
                ClassLoader mainAppLoader = ClassLoader.getSystemClassLoader();
                if (mainAppLoader != InitializeAsync.class.getClassLoader()) {
                    URL agentClassPath = InitializeAsync.getClassPathFor(InitializeAsync.class);
                    URL asmClassPath = InitializeAsync.getClassPathFor(ClassVisitor.class);
                    URL asmClassPath2 = InitializeAsync.getClassPathFor(ClassNode.class);
                    URL asmClassPath3 = InitializeAsync.getClassPathFor(Analyzer.class);
                    try {
                        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        method.setAccessible(true);
                        method.invoke((Object)mainAppLoader, agentClassPath);
                        method.invoke((Object)mainAppLoader, asmClassPath);
                        method.invoke((Object)mainAppLoader, asmClassPath2);
                        method.invoke((Object)mainAppLoader, asmClassPath3);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Add URL failed: " + agentClassPath, ex);
                    }
                }
            }
            ByteBuddyAgent.attach(new File(jarName), pid);
        }
        catch (Throwable e) {
            if (jarName != null) {
                throw new RuntimeException("Error activating orbit-async agent from " + jarName, e);
            }
            throw new RuntimeException("Error activating orbit-async agent", e);
        }
    }

    public static void init() {
    }

    public static boolean isRunning() {
        return isRunning;
    }

    static {
        if (!isRunning) {
            try {
                InitializeAsync.loadAgent();
                while (!"true".equals(System.getProperty(EA_ASYNC_RUNNING, "false"))) {
                    Thread.sleep(1L);
                }
                isRunning = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Error attaching ea-async java agent", e);
            }
        }
    }
}

