/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper.properties;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class CircularDefinitionPreventer {
    private final List<VisitedProperty> entriesVisited = new LinkedList<VisitedProperty>();
    private final Set<String> keysUsed = new HashSet<String>();

    CircularDefinitionPreventer() {
    }

    public CircularDefinitionPreventer visited(String key, String value) {
        this.entriesVisited.add(new VisitedProperty(key, value));
        if (this.keysUsed.contains(key)) {
            this.circularDefinition();
        } else {
            this.keysUsed.add(key);
        }
        return this;
    }

    private void circularDefinition() {
        StringBuilder buffer = new StringBuilder("Circular property definition: ");
        Iterator<VisitedProperty> iterator = this.entriesVisited.iterator();
        while (iterator.hasNext()) {
            VisitedProperty visited = iterator.next();
            buffer.append(visited.key).append("=").append(visited.value);
            if (!iterator.hasNext()) continue;
            buffer.append(" -> ");
        }
        throw new IllegalArgumentException(buffer.toString());
    }

    private static class VisitedProperty {
        private final String key;
        private final String value;

        private VisitedProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

