/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBranchMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchInfo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import com.e_gineering.maven.gitflowhelper.ScmUtils;
import com.e_gineering.maven.gitflowhelper.properties.ExpansionBuffer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

@Mojo(name="tag-master", defaultPhase=LifecyclePhase.INSTALL)
public class TagMasterMojo
extends AbstractGitflowBranchMojo {
    @Parameter(property="gitURLExpression")
    private String gitURLExpression;
    @Parameter(defaultValue="${project.version}", property="tag", required=true)
    private String tag;

    @Override
    protected void execute(GitBranchInfo gitBranchInfo) throws MojoExecutionException, MojoFailureException {
        block7: {
            if (this.project.isExecutionRoot() && (gitBranchInfo.getType().equals((Object)GitBranchType.MASTER) || gitBranchInfo.getType().equals((Object)GitBranchType.SUPPORT))) {
                String gitURL;
                if (this.gitURLExpression == null) {
                    this.gitURLExpression = ScmUtils.resolveUrlOrExpression(this.project);
                }
                if (!(gitURL = this.resolveExpression(this.gitURLExpression)).startsWith("scm:git:")) {
                    gitURL = "scm:git:" + gitURL;
                }
                this.getLog().debug((CharSequence)("gitURLExpression: '" + this.gitURLExpression + "' resolved to: '" + gitURL + "'"));
                ExpansionBuffer eb = new ExpansionBuffer(gitURL);
                if (!eb.hasMoreLegalPlaceholders()) {
                    this.getLog().info((CharSequence)("Tagging SCM for CI build matching branchPattern: [" + gitBranchInfo.getPattern() + "]"));
                    try {
                        ScmRepository repository = this.scmManager.makeScmRepository(gitURL);
                        ScmProvider provider = this.scmManager.getProviderByRepository(repository);
                        String sanitizedTag = provider.sanitizeTagName(this.tag);
                        this.getLog().info((CharSequence)("Sanitized tag: '" + sanitizedTag + "'"));
                        ScmTagParameters tagParams = new ScmTagParameters("Release tag [" + sanitizedTag + "] generated by gitflow-helper-maven-plugin.");
                        tagParams.setRemoteTagging(true);
                        TagScmResult tagScmResult = provider.tag(repository, new ScmFileSet(this.project.getBasedir()), sanitizedTag, tagParams);
                        if (!tagScmResult.isSuccess()) {
                            this.getLog().error((CharSequence)"Provider message:");
                            this.getLog().error((CharSequence)tagScmResult.getProviderMessage());
                            this.getLog().error((CharSequence)"Command output:");
                            this.getLog().error((CharSequence)tagScmResult.getCommandOutput());
                            throw new MojoFailureException(tagScmResult.getProviderMessage());
                        }
                        break block7;
                    }
                    catch (ScmException scme) {
                        throw new MojoFailureException("Unable to tag master branch.", (Throwable)scme);
                    }
                }
                throw new MojoFailureException("Unable to resolve gitURLExpression: " + this.gitURLExpression + ". Leaving build configuration unaltered.");
            }
        }
    }
}

