/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.manifest;

import com.dynatrace.tools.android.manifest.AndroidManifestProcessor;
import com.dynatrace.tools.android.manifest.ManifestInstrumentorBase;
import com.dynatrace.tools.android.util.Utils;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;

public class ManifestInstrumentorApk
extends ManifestInstrumentorBase
implements Action<Task> {
    private static final String GET_MANIFEST_OUTPUT_DIRECTORY = "getManifestOutputDirectory";
    private AndroidManifestProcessor processor;

    public ManifestInstrumentorApk(String subVariantName, boolean failsOnWarning) {
        super(subVariantName);
        this.processor = new AndroidManifestProcessor(failsOnWarning);
    }

    public void execute(Task task) {
        File manifestOutputDirectory;
        try {
            manifestOutputDirectory = (File)Utils.getValue(task, GET_MANIFEST_OUTPUT_DIRECTORY);
        }
        catch (Exception e) {
            logger.error("Failed to determine the location of the AndroidManifest.xml file. Cannot add the Dynatrace Application class to the Android Manifest");
            throw new GradleException("Failed to determine the location of the AndroidManifest.xml file. Cannot add the Dynatrace Application class to the Android Manifest", (Throwable)e);
        }
        this.processor.instrumentManifest(this.selectManifestFile(manifestOutputDirectory.toPath()));
    }
}

