/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.manifest;

import com.dynatrace.tools.android.InstrumentationException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AndroidManifestProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"AndroidManifestProcessor");
    private static final String DT_APPLICATION_CLASS = "com.dynatrace.android.app.Application";
    private static final String ANDROID_APPLICATION_CLASS = "android.app.Application";
    private static final String KEY_ANDROID_APPLICATION = "android:name";
    private boolean failsOnWarning;

    public AndroidManifestProcessor(boolean failsOnWarning) {
        this.failsOnWarning = failsOnWarning;
    }

    public void instrumentManifest(Path inputManifest) {
        this.instrumentManifest(inputManifest, null);
    }

    public void instrumentManifest(Path inputManifest, Path outputManifest) {
        Document doc;
        if (inputManifest == null) {
            String msg = "The AndroidManifest file is null";
            logger.warn(msg);
            if (this.failsOnWarning) {
                throw new IllegalArgumentException(msg);
            }
            return;
        }
        inputManifest = inputManifest.toAbsolutePath();
        if (outputManifest != null) {
            outputManifest = outputManifest.toAbsolutePath();
        }
        logger.debug("Verifying Android manifest at " + inputManifest.toString());
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(Files.newInputStream(inputManifest, new OpenOption[0]));
        }
        catch (Exception e) {
            this.logWarning("Failed to verify the AndroidManifest file at " + inputManifest.toString(), e);
            return;
        }
        Node application = doc.getElementsByTagName("application").item(0);
        NamedNodeMap attributes = application.getAttributes();
        Node nameAttribute = attributes.getNamedItem(KEY_ANDROID_APPLICATION);
        try {
            if (outputManifest == null) {
                outputManifest = inputManifest;
            } else {
                Files.createDirectories(outputManifest.getParent(), new FileAttribute[0]);
            }
            if (nameAttribute == null || ANDROID_APPLICATION_CLASS.equals(nameAttribute.getNodeValue())) {
                logger.info("Inserting the Dynatrace Application class into the Android manifest");
                ((Element)application).setAttribute(KEY_ANDROID_APPLICATION, DT_APPLICATION_CLASS);
                Transformer xmlTransformer = TransformerFactory.newInstance().newTransformer();
                xmlTransformer.setOutputProperty("indent", "yes");
                xmlTransformer.setOutputProperty("method", "xml");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(Files.newOutputStream(outputManifest, new OpenOption[0]));
                xmlTransformer.transform(source, result);
            } else if (!outputManifest.equals(inputManifest)) {
                Files.copy(inputManifest, outputManifest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            this.logWarning("Failed to write modified manifest file at " + outputManifest.toString(), e);
        }
    }

    private void logWarning(String message, Exception e) {
        logger.warn(message, (Throwable)e);
        if (this.failsOnWarning) {
            throw new InstrumentationException(message, e);
        }
    }
}

