/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.api;

import com.dynatrace.android.instrumentation.filter.ClassExclusionFilter;
import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.filter.CustomClassExclusionFilter;
import com.dynatrace.android.instrumentation.filter.CustomMethodExclusionFilter;
import com.dynatrace.android.instrumentation.filter.MethodExclusionFilter;
import com.dynatrace.android.instrumentation.filter.MethodLevelFilter;
import com.dynatrace.android.instrumentation.filter.PackageExclusionFilter;
import com.dynatrace.tools.android.api.ExcludeFilterOptions;
import java.util.ArrayList;
import java.util.List;

public interface ExcludeOptions {
    public List<String> getPackages();

    public List<String> getClasses();

    public List<String> getMethods();

    public List<? extends ExcludeFilterOptions> getFilters();

    default public List<ClassLevelFilter> getClassLevelFilter() {
        List<? extends ExcludeFilterOptions> list;
        List<String> classes;
        ArrayList<ClassLevelFilter> filters = new ArrayList<ClassLevelFilter>();
        List<String> packages = this.getPackages();
        if (packages != null) {
            for (String string : packages) {
                filters.add(new PackageExclusionFilter(string));
            }
        }
        if ((classes = this.getClasses()) != null) {
            for (String classFilterStr : classes) {
                filters.add(new ClassExclusionFilter(classFilterStr));
            }
        }
        if ((list = this.getFilters()) != null) {
            for (ExcludeFilterOptions excludeFilterOptions : list) {
                if (!excludeFilterOptions.isClassLevelFilter()) continue;
                filters.add(new CustomClassExclusionFilter(excludeFilterOptions.getClassName()));
            }
        }
        return filters;
    }

    default public List<MethodLevelFilter> getMethodLevelFilter() {
        List<? extends ExcludeFilterOptions> customFilters;
        ArrayList<MethodLevelFilter> filters = new ArrayList<MethodLevelFilter>();
        List<String> methods = this.getMethods();
        if (methods != null) {
            for (String methodFilterStr : methods) {
                filters.add(new MethodExclusionFilter(methodFilterStr));
            }
        }
        if ((customFilters = this.getFilters()) != null) {
            for (ExcludeFilterOptions excludeFilterOptions : customFilters) {
                if (excludeFilterOptions.isClassLevelFilter()) continue;
                filters.add(new CustomMethodExclusionFilter(excludeFilterOptions.getClassName(), excludeFilterOptions.getMethodName(), excludeFilterOptions.getMethodDescription()));
            }
        }
        return filters;
    }
}

