/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.AGPVersion;
import com.dynatrace.tools.android.DynatracePlugin;
import com.dynatrace.tools.android.DynatraceTransformer;
import com.dynatrace.tools.android.InstrumentationFlavorParser;
import com.dynatrace.tools.android.PrintVariantAffiliationTask;
import com.dynatrace.tools.android.Version;
import com.dynatrace.tools.android.api.VerificationUtil;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.VariantConfigurationUtil;
import com.dynatrace.tools.android.manifest.ManifestInstrumentorApk;
import com.dynatrace.tools.android.manifest.ManifestInstrumentorAppBundle;
import com.dynatrace.tools.android.manifest.ManifestInstrumentorMultiApk;
import com.dynatrace.tools.android.manifest.StrictErrorAction;
import com.dynatrace.tools.android.util.Utils;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class InstrumentationPlugin
implements Plugin<Project> {
    private static final String ENABLE_SESSION_REPLAY = "dynatrace.enableSessionReplay";
    private static final String LOAD_REPLAY_LIB = "dynatrace.addSessionReplayDependency";
    private static final String INSTRUMENTATION_FLAVOR = "dynatrace.instrumentationFlavor";

    static void applyPlugin(ObjectConfigurationAction objectConfigurationAction) {
        objectConfigurationAction.plugin(InstrumentationPlugin.class);
    }

    private static String generateTransformTaskNamePrefix(Transform transformer) {
        return "transform" + transformer.getInputTypes().stream().map(inputType -> CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, inputType.name())).sorted().collect(Collectors.joining("And")) + "With" + Utils.capitalize(transformer.getName()) + "For";
    }

    static DynatraceExtension determineExtension(Project project) {
        DynatraceExtension extension = (DynatraceExtension)project.getRootProject().getExtensions().findByType(DynatraceExtension.class);
        if (extension == null) {
            extension = (DynatraceExtension)project.getExtensions().findByType(DynatraceExtension.class);
        }
        return extension;
    }

    public void apply(@NotNull Project project) {
        InstrumentationFlavor instrFlavor;
        AppExtension androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        DynatraceExtension extension = InstrumentationPlugin.determineExtension(project);
        if (extension == null) {
            throw new GradleException("No Dynatrace extension found");
        }
        boolean isSessionReplayEnabled = Boolean.parseBoolean((String)project.findProperty(ENABLE_SESSION_REPLAY));
        try {
            instrFlavor = new InstrumentationFlavorParser().parse((String)project.getRootProject().findProperty(INSTRUMENTATION_FLAVOR));
        }
        catch (IllegalArgumentException e) {
            throw new GradleException("Can't parse value from property 'dynatrace.instrumentationFlavor'", (Throwable)e);
        }
        DynatraceTransformer transformer = new DynatraceTransformer(extension, androidExt, isSessionReplayEnabled, instrFlavor);
        androidExt.registerTransform((Transform)transformer, new Object[0]);
        project.getTasks().register("printVariantAffiliation", PrintVariantAffiliationTask.class, printVariantAffiliationTask -> {
            printVariantAffiliationTask.setGroup("transformation");
            printVariantAffiliationTask.setDescription("Prints which Dynatrace variant configuration is used for each variant");
        });
        boolean isApplicationModule = project.getPlugins().hasPlugin("com.android.application");
        if (isApplicationModule) {
            Configuration config = project.getConfigurations().getByName("api");
            config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DynatracePlugin.agentDependency())));
            boolean loadLib = Boolean.parseBoolean((String)project.findProperty(LOAD_REPLAY_LIB));
            if (loadLib) {
                config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)("com.dynatrace.agent:android-replay-agent:" + Version.getVersion()))));
            }
        }
        project.afterEvaluate(projectParam -> {
            if (extension.isStrictMode() && extension.getConfigurations().isEmpty()) {
                throw new GradleException("No configuration for the Dynatrace Android Gradle plugin found! Please copy the configuration block from the instrumentation wizard to the proper location.");
            }
            if (extension.isPluginEnabled()) {
                extension.getConfigurations().configureEach(config -> VerificationUtil.verifyVariantConfiguration("Invalid configuration '" + config.getName() + "': ", config, isSessionReplayEnabled));
            }
            String genericTaskName = InstrumentationPlugin.generateTransformTaskNamePrefix(transformer);
            AGPVersion agpVersion = Utils.determineAndVerifyAGPVersion();
            androidExt.getApplicationVariants().configureEach(applicationVariant -> {
                Optional<VariantConfiguration> result = !extension.isPluginEnabled() ? Optional.empty() : VariantConfigurationUtil.determineVariantConfiguration(extension, applicationVariant.getName());
                TaskProvider transformTaskProvider = project.getTasks().named(genericTaskName + Utils.capitalize(applicationVariant.getName()));
                transformTaskProvider.configure(this.configureTransformTask(androidExt, (ApplicationVariant)applicationVariant, transformer, result));
                if (isApplicationModule) {
                    if (result.isPresent()) {
                        VariantConfiguration conf = result.get();
                        if (conf.isEnabled()) {
                            TaskProvider manifestTaskProvider = project.getTasks().named("process" + Utils.capitalize(applicationVariant.getName()) + "Manifest");
                            manifestTaskProvider.configure(this.configureManifestTask((ApplicationVariant)applicationVariant, agpVersion, conf.getDebug().isFailOnWarnings()));
                        }
                    } else if (extension.isStrictMode() && extension.isPluginEnabled()) {
                        TaskProvider manifestTaskProvider = project.getTasks().named("process" + Utils.capitalize(applicationVariant.getName()) + "Manifest");
                        manifestTaskProvider.configure(this.configureManifestTaskError(applicationVariant.getName()));
                    }
                }
            });
        });
    }

    private Action<? super Task> configureTransformTask(AppExtension androidExt, ApplicationVariant applicationVariant, DynatraceTransformer transformer, Optional<VariantConfiguration> result) {
        return task -> {
            TaskInputs input = task.getInputs();
            TaskOutputs output = task.getOutputs();
            boolean caching = false;
            if (result.isPresent()) {
                VariantConfiguration origConf = (VariantConfiguration)result.get();
                transformer.addVariantSpecificConfiguration(applicationVariant.getName(), origConf);
                input.property("variantConfiguration", (Object)VariantConfigurationUtil.copy(origConf));
                caching = origConf.isEnabled();
            }
            input.files(new Object[]{androidExt.getBootClasspath()}).withPropertyName("bootClasspath").withPathSensitivity(PathSensitivity.NAME_ONLY);
            output.file((Object)new File(task.getTemporaryDir(), "transform.ser")).withPropertyName("incrementalState");
            if (!caching) {
                output.cacheIf(task1 -> false);
            }
        };
    }

    private Action<? super Task> configureManifestTask(ApplicationVariant applicationVariant, AGPVersion agpVersion, boolean failsOnWarning) {
        return manifestProcessorTask -> {
            TaskInputs input = manifestProcessorTask.getInputs();
            input.property("failsOnWarning", (Object)failsOnWarning);
            applicationVariant.getOutputs().configureEach(apkVariant -> {
                String subVariantName = apkVariant.getDirName().replaceAll("[/$\\\\]", "");
                switch (agpVersion) {
                    case V3_1: 
                    case V3_2: {
                        manifestProcessorTask.doLast((Action)new ManifestInstrumentorApk(subVariantName, failsOnWarning));
                        break;
                    }
                    case V3_3: 
                    case V3_4: 
                    case V3_5: 
                    case V3_6: 
                    case V4_0: {
                        manifestProcessorTask.doLast((Action)new ManifestInstrumentorAppBundle(subVariantName, agpVersion, failsOnWarning));
                        break;
                    }
                    default: {
                        manifestProcessorTask.doLast((Action)new ManifestInstrumentorMultiApk(subVariantName, failsOnWarning));
                    }
                }
            });
        };
    }

    private Action<? super Task> configureManifestTaskError(String variantName) {
        return manifestProcessorTask -> {
            TaskInputs input = manifestProcessorTask.getInputs();
            input.property("strictModeError", (Object)variantName);
            manifestProcessorTask.doLast((Action)new StrictErrorAction(variantName));
        };
    }
}

