/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.instrumentor;

import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionInstrumentor {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstructionInstrumentor");
    private ClassLoader classLoader;
    private List<SensorGroup<InstructionSensor>> sensors;
    private boolean warningsAsErrors;

    public InstructionInstrumentor(ClassLoader classLoader, List<SensorGroup<InstructionSensor>> sensors, boolean warningsAsErrors) {
        this.classLoader = classLoader;
        this.sensors = sensors;
        this.warningsAsErrors = warningsAsErrors;
    }

    public boolean transformMethod(MethodNode method, ExclusionManager exclusionManager) {
        boolean modified = false;
        ArrayList<MethodInsnNode> methodInstructions = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode instruction : method.instructions) {
            if (!(instruction instanceof MethodInsnNode)) continue;
            methodInstructions.add((MethodInsnNode)instruction);
        }
        for (MethodInsnNode node : methodInstructions) {
            Class<?> clazzOwner;
            if (node.owner.startsWith("[")) continue;
            String className = Type.getObjectType((String)node.owner).getClassName();
            if (exclusionManager.filterInvokeInstruction(className, node.name, node.desc)) {
                logger.debug("exclude invoke instruction {}.{}{}", new Object[]{className, node.name, node.desc});
                continue;
            }
            try {
                clazzOwner = Class.forName(className, false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                logger.info("skip instruction with unknown method call {}.{}{}, {}", new Object[]{className, node.name, node.desc, e.toString()});
                continue;
            }
            catch (Throwable t) {
                if (this.warningsAsErrors || t instanceof UnsupportedClassVersionError) {
                    throw t;
                }
                logger.info("skip instruction with unknown method call {}.{}{}, {}", new Object[]{className, node.name, node.desc, t.toString()});
                continue;
            }
            Optional<InstructionSensor> result = this.sensors.stream().filter(sensorGroup -> sensorGroup.matchClass(clazzOwner)).flatMap(sensorGroup -> sensorGroup.getSensors().stream()).filter(sensor -> sensor.matchInstruction(clazzOwner, node.name, node.desc)).findAny();
            if (!result.isPresent()) continue;
            logger.debug("Instrument method call {}.{}{}", new Object[]{className, node.name, node.desc});
            result.get().transform(method, node);
            modified = true;
        }
        return modified;
    }
}

