/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SessionReplayWindowCallbackTransformerFactory
implements TransformerFactory {
    private static final String WINDOW = "android.view.Window";
    private static final String WINDOW_CALLBACK = "android.view.Window$Callback";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateSensor(classLoader));
        return new DefaultSubTransformer("SessionReplayWindowCallbackTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateSensor(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> window = Class.forName(WINDOW, false, classLoader);
        Class<?> windowCallback = Class.forName(WINDOW_CALLBACK, false, classLoader);
        Method setCallback = window.getDeclaredMethod("setCallback", windowCallback);
        Class<?> instrumentorApi = Class.forName("com.dynatrace.android.internal.api.InstrumentorAPI", false, classLoader);
        Method instrumentedSetCallback = instrumentorApi.getDeclaredMethod("setWindowCallback", window, windowCallback);
        ReplaceInstructionSensor replaceSetCallbackSensor = new ReplaceInstructionSensor(setCallback, instrumentedSetCallback);
        return new SensorGroupImpl<InstructionSensor>("SRWindowCallbackSensor", window, replaceSetCallbackSensor);
    }
}

