/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.ExitConstructorTransformation;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionReplayScrollTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"SessionReplayScrollTransformerFactory");
    private static final String ABS_LIST_VIEW = "android.widget.AbsListView";
    private static final String LV_ON_SCROLL_LISTENER = "android.widget.AbsListView$OnScrollListener";
    private static final String RECYCLER_VIEW = "androidx.recyclerview.widget.RecyclerView";
    private static final String NESTED_SCROLL_VIEW = "androidx.core.widget.NestedScrollView";
    private static final String NESTED_SV_LISTENER = "androidx.core.widget.NestedScrollView$OnScrollChangeListener";
    private static final String CONTEXT = "android.content.Context";
    private static final String ATTRIBUTE_SET = "android.util.AttributeSet";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        try {
            methodSensors.add(this.generateRecyclerViewSensor(classLoader));
        }
        catch (ClassNotFoundException e) {
            logger.debug("Deactivate instrumentation for RecyclerView scroll events, because it is not part of the classpath");
        }
        try {
            methodSensors.add(this.generateNestedScrollViewSensor(classLoader));
        }
        catch (ClassNotFoundException e) {
            logger.debug("Deactivate instrumentation for NestedScrollView scroll events, because it is not part of the classpath");
        }
        return new DefaultSubTransformer("SessionReplayScrollTransformer", Collections.singletonList(this.generateListViewSensor(classLoader)), methodSensors, classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateListViewSensor(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> absListView = Class.forName(ABS_LIST_VIEW, false, classLoader);
        Class<?> onScrollListener = Class.forName(LV_ON_SCROLL_LISTENER, false, classLoader);
        Method setOnScrollListener = absListView.getDeclaredMethod("setOnScrollListener", onScrollListener);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.InstrumentorAPI", false, classLoader);
        Method instrumentedSetOnScrollListener = callback.getDeclaredMethod("setOnScrollListener", absListView, onScrollListener);
        ReplaceInstructionSensor sensorSetOnScrollListener = new ReplaceInstructionSensor(setOnScrollListener, instrumentedSetOnScrollListener);
        return new SensorGroupImpl<InstructionSensor>("SRListViewScrollSensor", absListView, sensorSetOnScrollListener);
    }

    private SensorGroup<MethodSensor> generateNestedScrollViewSensor(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> nestedScrollView = Class.forName(NESTED_SCROLL_VIEW, false, classLoader);
        Class<?> nsvListener = Class.forName(NESTED_SV_LISTENER, false, classLoader);
        Method setOnScrollListener = nestedScrollView.getDeclaredMethod("setOnScrollChangeListener", nsvListener);
        Class<?> contextClass = Class.forName(CONTEXT, false, classLoader);
        Class<?> attributeSetClass = Class.forName(ATTRIBUTE_SET, false, classLoader);
        Constructor<?> svConstructor = nestedScrollView.getDeclaredConstructor(contextClass, attributeSetClass, Integer.TYPE);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.nestedscrollview.callback.NestedScrollViewCallback", false, classLoader);
        Method callbackSetListener = callback.getDeclaredMethod("wrapOnScrollChangeListener", nsvListener);
        MethodTransformation setterTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, instructions -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(callbackSetListener));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
        });
        MethodTransformation constructorTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodExitWithoutExceptionHandling(methodNode, instructions -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, "androidx/core/widget/NestedScrollView", "mOnScrollChangeListener", "Landroidx/core/widget/NestedScrollView$OnScrollChangeListener;"));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(callbackSetListener));
            instructions.add((AbstractInsnNode)new FieldInsnNode(181, "androidx/core/widget/NestedScrollView", "mOnScrollChangeListener", "Landroidx/core/widget/NestedScrollView$OnScrollChangeListener;"));
        });
        return new SensorGroupImpl<MethodSensor>("SRNestedScrollViewScrollSensor", clazz -> clazz == nestedScrollView, new MethodSensorImpl(svConstructor, constructorTransformation), new MethodSensorImpl(setOnScrollListener, setterTransformation));
    }

    private SensorGroup<MethodSensor> generateRecyclerViewSensor(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> recyclerView = Class.forName(RECYCLER_VIEW, false, classLoader);
        Method clearOnScrollListeners = recyclerView.getDeclaredMethod("clearOnScrollListeners", new Class[0]);
        Class<?> contextClass = Class.forName(CONTEXT, false, classLoader);
        Class<?> attributeSetClass = Class.forName(ATTRIBUTE_SET, false, classLoader);
        Constructor<?> rvConstructor = recyclerView.getDeclaredConstructor(contextClass, attributeSetClass, Integer.TYPE);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.recyclerview.callback.RecyclerViewCallback", false, classLoader);
        Method addOnScrollListener = callback.getDeclaredMethod("addOnScrollListener", recyclerView);
        return new SensorGroupImpl<MethodSensor>("SRRecyclerViewScrollSensor", clazz -> clazz == recyclerView, new MethodSensorImpl(rvConstructor, new ExitConstructorTransformation(addOnScrollListener, ParameterInstructionProvider.withThis())), new MethodSensorImpl(clearOnScrollListeners, new ExitConstructorTransformation(addOnScrollListener, ParameterInstructionProvider.withThis())));
    }
}

