/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class LocationTransformerFactory
implements TransformerFactory {
    private static final String LOCATION_LISTENER = "android.location.LocationListener";
    private static final String LOCATION = "android.location.Location";
    private static final String DYNATRACE = "com.dynatrace.android.agent.Dynatrace";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateLocationListenerSensors(classLoader));
        return new DefaultSubTransformer("LocationTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classLoader, warningsAsErrors);
    }

    private SensorGroup<MethodSensor> generateLocationListenerSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> dynatraceClass = Class.forName(DYNATRACE, false, classLoader);
        Class<?> locationListenerClass = Class.forName(LOCATION_LISTENER, true, classLoader);
        Class<?> locationClass = Class.forName(LOCATION, true, classLoader);
        Method onLocationChanged = locationListenerClass.getDeclaredMethod("onLocationChanged", locationClass);
        Method setGpsLocation = dynatraceClass.getDeclaredMethod("setGpsLocation", locationClass);
        return new SensorGroupImpl<MethodSensor>("LocationSensor", locationListenerClass, new MethodSensorImpl(onLocationChanged, new StartMethodTransformation(setGpsLocation, ParameterInstructionProvider.withAllParameters(onLocationChanged))));
    }
}

