/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.agent;

import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class AutoStartTransformation
implements MethodTransformation {
    private static final String DYNATRACE_CONFIGURATION_BUILDER = "com.dynatrace.android.agent.conf.DynatraceConfigurationBuilder";
    private static final String APPMON_CONFIGURATION_BUILDER = "com.dynatrace.android.agent.conf.AppMonConfigurationBuilder";
    private static final String CONFIGURATION_BUILDER = "com.dynatrace.android.agent.conf.ConfigurationBuilder";
    private Constructor<?> builderCtor;
    private Class<?> builderClass;
    private Method buildConfigurationMethod;
    private BuilderConfiguration builderConfig;

    public AutoStartTransformation(BuilderConfiguration builderConfig, ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException {
        this.builderConfig = builderConfig;
        if (builderConfig.isSaas) {
            this.builderClass = Class.forName(DYNATRACE_CONFIGURATION_BUILDER, false, classLoader);
            this.builderCtor = this.builderClass.getConstructor(String.class, String.class);
        } else {
            this.builderClass = Class.forName(APPMON_CONFIGURATION_BUILDER, false, classLoader);
            this.builderCtor = this.builderClass.getConstructor(String.class, String.class);
        }
        this.buildConfigurationMethod = Class.forName(CONFIGURATION_BUILDER, false, classLoader).getDeclaredMethod("buildConfiguration", new Class[0]);
    }

    private InsnList getConfigurationInsn() {
        InsnList instr = new InsnList();
        instr.add((AbstractInsnNode)new TypeInsnNode(187, Type.getType(this.builderClass).getInternalName()));
        instr.add((AbstractInsnNode)new InsnNode(89));
        Utils.pushValueToStack(instr, this.builderConfig.applicationId);
        Utils.pushValueToStack(instr, this.builderConfig.beaconUrl);
        instr.add((AbstractInsnNode)Utils.generateConstructorCall(this.builderCtor));
        instr.add((AbstractInsnNode)Utils.generateMethodCall(this.buildConfigurationMethod));
        instr.add((AbstractInsnNode)new InsnNode(176));
        return instr;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        methodNode.instructions.clear();
        methodNode.instructions.add(this.getConfigurationInsn());
    }

    public static class BuilderConfiguration {
        public final boolean isSaas;
        public final String applicationId;
        public final String beaconUrl;

        public BuilderConfiguration(String applicationId, String beaconUrl, boolean isSaas) {
            this.isSaas = isSaas;
            this.applicationId = applicationId;
            this.beaconUrl = beaconUrl;
        }
    }
}

