/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.action;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.drextended.actionhandler.action.Cancelable;
import com.drextended.actionhandler.action.RequestAction;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;

public abstract class RxRequestAction<RM, M>
extends RequestAction<RM, M>
implements Cancelable {
    protected CompositeSubscription mSubscription;
    protected boolean mUnsubscribeOnNewRequest = true;

    public RxRequestAction() {
    }

    public RxRequestAction(boolean showProgressEnabled, boolean showDialog) {
        super(showProgressEnabled, showDialog);
    }

    public RxRequestAction(boolean showProgressEnabled, boolean showDialog, boolean unsubscribeOnNewRequest) {
        super(showProgressEnabled, showDialog);
        this.mUnsubscribeOnNewRequest = unsubscribeOnNewRequest;
    }

    @Override
    protected void onMakeRequest(final Context context, final View view, final String actionType, final M model, Object payload) {
        Observable<RM> observableRequest = this.getRequest(context, view, actionType, model, payload);
        if (observableRequest == null) {
            if (this.mShowProgressEnabled) {
                this.hideProgressDialog();
            }
            return;
        }
        if (this.mUnsubscribeOnNewRequest) {
            this.unsubscribe((Subscription)this.mSubscription);
        }
        if (this.mSubscription == null || this.mSubscription.isUnsubscribed()) {
            this.mSubscription = new CompositeSubscription();
        }
        this.mSubscription.add(observableRequest.compose(this.applySchedulers()).subscribe(new Subscriber<RM>(){

            public void onCompleted() {
                RxRequestAction.this.onResponseCompleted(context, view, actionType, model);
            }

            public void onError(Throwable e) {
                RxRequestAction.this.onResponseError(context, view, actionType, model, e);
            }

            public void onNext(RM response) {
                RxRequestAction.this.onResponseSuccess(context, view, actionType, model, response);
            }
        }));
    }

    @NonNull
    protected Observable.Transformer<RM, RM> applySchedulers() {
        return new Observable.Transformer<RM, RM>(){

            public Observable<RM> call(Observable<RM> r) {
                return r.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
            }
        };
    }

    protected void unsubscribe(Subscription subscription) {
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
        }
    }

    @Override
    public void cancel() {
        this.unsubscribe((Subscription)this.mSubscription);
    }

    @Deprecated
    @Nullable
    protected Observable<RM> getRequest(Context context, View view, String actionType, M model) {
        return null;
    }

    @Nullable
    protected Observable<RM> getRequest(Context context, View view, String actionType, M model, @Nullable Object payload) {
        return this.getRequest(context, view, actionType, model);
    }

    protected void onResponseCompleted(Context context, View view, String actionType, M oldModel) {
        if (this.mShowProgressEnabled) {
            this.hideProgressDialog();
        }
    }

    @Override
    protected void onResponseSuccess(Context context, View view, String actionType, M oldModel, RM response) {
        this.notifyOnActionFired(view, actionType, oldModel, response);
    }
}

