/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.action;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.PopupMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.drextended.actionhandler.R;
import com.drextended.actionhandler.action.Action;
import com.drextended.actionhandler.action.BaseAction;
import com.drextended.actionhandler.listener.ActionFireInterceptor;
import com.drextended.actionhandler.listener.OnActionDismissListener;
import com.drextended.actionhandler.listener.OnActionErrorListener;
import com.drextended.actionhandler.listener.OnActionFiredListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CompositeAction<M>
extends BaseAction<M>
implements OnActionFiredListener,
OnActionErrorListener,
OnActionDismissListener,
ActionFireInterceptor {
    protected final ActionItem[] mActions;
    protected final TitleProvider<M> mTitleProvider;
    protected boolean mShowAsPopupMenuEnabled;
    protected boolean mDisplayDialogForSingleAction = true;
    protected boolean mShowNonAcceptedActions = false;

    public CompositeAction(@StringRes int titleResId, boolean displayDialogForSingleAction, ActionItem ... actions) {
        this(new SimpleTitleProvider(titleResId), displayDialogForSingleAction, false, actions);
    }

    public CompositeAction(@StringRes int titleResId, boolean displayDialogForSingleAction, boolean showNonAcceptedActions, ActionItem ... actions) {
        this(new SimpleTitleProvider(titleResId), displayDialogForSingleAction, showNonAcceptedActions, actions);
    }

    public CompositeAction(@StringRes int titleResId, ActionItem ... actions) {
        this(new SimpleTitleProvider(titleResId), true, false, actions);
    }

    public CompositeAction(TitleProvider<M> titleProvider, ActionItem ... actions) {
        this(titleProvider, true, false, actions);
    }

    public CompositeAction(TitleProvider<M> titleProvider, boolean displayDialogForSingleAction, ActionItem ... actions) {
        this(titleProvider, displayDialogForSingleAction, false, actions);
    }

    public CompositeAction(TitleProvider<M> titleProvider, boolean displayDialogForSingleAction, boolean showNonAcceptedActions, ActionItem ... actions) {
        if (actions == null) {
            throw new InvalidParameterException("Provide at least one action");
        }
        this.mActions = actions;
        this.mTitleProvider = titleProvider;
        this.mDisplayDialogForSingleAction = displayDialogForSingleAction;
        this.mShowNonAcceptedActions = showNonAcceptedActions;
        for (ActionItem item : this.mActions) {
            if (!(item.action instanceof BaseAction)) continue;
            BaseAction baseAction = (BaseAction)item.action;
            baseAction.addActionFiredListener(this);
            baseAction.addActionErrorListener(this);
            baseAction.addActionDismissListener(this);
            baseAction.addActionFireInterceptor(this);
        }
    }

    public void setShowAsPopupMenuEnabled(boolean showAsPopupMenuEnabled) {
        this.mShowAsPopupMenuEnabled = showAsPopupMenuEnabled;
    }

    public void setDisplayDialogForSingleAction(boolean displayDialogForSingleAction) {
        this.mDisplayDialogForSingleAction = displayDialogForSingleAction;
    }

    public void setShowNonAcceptedActions(boolean showNonAcceptedActions) {
        this.mShowNonAcceptedActions = showNonAcceptedActions;
    }

    @Override
    public boolean isModelAccepted(Object model) {
        for (ActionItem action : this.mActions) {
            if (!action.action.isModelAccepted(model)) continue;
            return true;
        }
        return false;
    }

    private int getAcceptedActionCount(Object model) {
        int count = 0;
        for (ActionItem action : this.mActions) {
            if (!action.action.isModelAccepted(model)) continue;
            ++count;
        }
        return count;
    }

    private ActionItem getFirstAcceptedActionItem(M model) {
        for (ActionItem action : this.mActions) {
            if (!action.action.isModelAccepted(model)) continue;
            return action;
        }
        return null;
    }

    @Override
    public void onFireAction(Context context, @Nullable View view, @Nullable String actionType, @Nullable M model) {
        if (!this.mDisplayDialogForSingleAction && this.getAcceptedActionCount(model) == 1) {
            ActionItem actionItem = this.getFirstAcceptedActionItem(model);
            this.fireActionItem(context, view, actionType, model, actionItem);
        } else {
            this.showMenu(context, view, actionType, model);
        }
    }

    private void fireActionItem(Context context, @Nullable View view, @Nullable String actionType, @Nullable M model, ActionItem actionItem) {
        if (actionItem != null && !this.interceptActionFire(context, view, actionType, model, actionItem.action)) {
            actionItem.action.onFireAction(context, view, actionType, model);
        }
    }

    private void showMenu(Context context, View view, String actionType, final M model) {
        final List<ActionItem> menuItems = this.prepareMenuListItems(model);
        if (this.mShowAsPopupMenuEnabled) {
            PopupMenu popupMenu = this.buildPopupMenu(context, view, actionType, model, menuItems);
            popupMenu.show();
        } else {
            AdapterView.OnItemClickListener clickListener;
            String title = this.mTitleProvider.getTitle(context, model);
            AlertDialog.Builder builder = this.buildAlertDialog(context, view, actionType, model, title, menuItems);
            AlertDialog dialog = builder.create();
            if (this.mShowNonAcceptedActions && (clickListener = dialog.getListView().getOnItemClickListener()) != null) {
                dialog.getListView().setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        if (((ActionItem)menuItems.get((int)position)).action.isModelAccepted(model)) {
                            clickListener.onItemClick(parent, view, position, id2);
                        }
                    }
                });
            }
            if (title == null) {
                dialog.requestWindowFeature(1);
            }
            dialog.show();
        }
    }

    @NonNull
    protected List<ActionItem> prepareMenuListItems(M model) {
        if (this.mShowNonAcceptedActions) {
            return Arrays.asList(this.mActions);
        }
        int count = this.mActions.length;
        ArrayList<ActionItem> menuItems = new ArrayList<ActionItem>(count);
        for (int index = 0; index < count; ++index) {
            ActionItem item = this.mActions[index];
            if (!item.action.isModelAccepted(model)) continue;
            menuItems.add(item);
        }
        return menuItems;
    }

    protected PopupMenu buildPopupMenu(final Context context, final View view, final String actionType, final M model, final List<ActionItem> menuItems) {
        PopupMenu popupMenu = new PopupMenu(context, view);
        Menu menu = popupMenu.getMenu();
        int count = menuItems.size();
        for (int index = 0; index < count; ++index) {
            ActionItem item = menuItems.get(index);
            menu.add(0, index, 0, (CharSequence)item.titleProvider.getTitle(context, model));
            if (!this.mShowNonAcceptedActions) continue;
            menu.getItem(index).setEnabled(item.action.isModelAccepted(model));
        }
        final AtomicBoolean activated = new AtomicBoolean(false);
        popupMenu.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                activated.set(true);
                ActionItem actionItem = (ActionItem)menuItems.get(item.getItemId());
                if (item.isEnabled()) {
                    CompositeAction.this.fireActionItem(context, view, actionItem.actionType, model, actionItem);
                } else {
                    CompositeAction.this.notifyOnActionDismiss("The model is not accepted for selected action", view, actionType, model);
                }
                return true;
            }
        });
        popupMenu.setOnDismissListener(new PopupMenu.OnDismissListener(){

            public void onDismiss(PopupMenu menu) {
                if (!activated.get()) {
                    CompositeAction.this.notifyOnActionDismiss("CompositeAction menu dismissed", view, actionType, model);
                }
            }
        });
        return popupMenu;
    }

    protected AlertDialog.Builder buildAlertDialog(final Context context, final View view, final String actionType, final M model, String title, final List<ActionItem> menuItems) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context).setTitle((CharSequence)title);
        builder.setAdapter((ListAdapter)new MenuItemsAdapter(this.getMenuItemLayoutResId(), menuItems, model, this.mShowNonAcceptedActions), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ActionItem actionItem = (ActionItem)menuItems.get(which);
                if (actionItem.action.isModelAccepted(model)) {
                    CompositeAction.this.fireActionItem(context, view, actionItem.actionType, model, actionItem);
                } else {
                    CompositeAction.this.notifyOnActionDismiss("Model is not acceptable for this action", view, actionType, model);
                }
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                CompositeAction.this.notifyOnActionDismiss("CompositeAction menu cancelled", view, actionType, model);
            }
        });
        return builder;
    }

    protected int getMenuItemLayoutResId() {
        return R.layout.item_menu_composit_action;
    }

    @Override
    public void onActionFired(View view, String actionType, Object model, Object result) {
        this.notifyOnActionFired(view, actionType, model, result);
    }

    @Override
    public void onActionError(Throwable throwable, View view, String actionType, Object model) {
        this.notifyOnActionError(throwable, view, actionType, model);
    }

    @Override
    public void onActionDismiss(String reason, View view, String actionType, Object model) {
        this.notifyOnActionDismiss(reason, view, actionType, model);
    }

    @Override
    public boolean onInterceptActionFire(Context context, View view, String actionType, Object model, Action action) {
        return this.interceptActionFire(context, view, actionType, model, action);
    }

    private static class MenuItemsAdapter
    extends BaseAdapter {
        private final int mItemLayoutResId;
        private final List<ActionItem> mItems;
        private final Object mModel;
        private final boolean mShowNonAcceptedActions;
        private final boolean mHasIcons;

        public MenuItemsAdapter(@LayoutRes int itemLayoutResId, List<ActionItem> menuItems, Object model, boolean showNonAcceptedActions) {
            this.mItemLayoutResId = itemLayoutResId;
            this.mItems = menuItems;
            this.mModel = model;
            this.mShowNonAcceptedActions = showNonAcceptedActions;
            this.mHasIcons = this.checkHasIcons(this.mItems);
        }

        private boolean checkHasIcons(List<ActionItem> items) {
            for (ActionItem item : items) {
                if (item.iconProvider == null) continue;
                return true;
            }
            return false;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            Context context = parent.getContext();
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)context).inflate(this.mItemLayoutResId, parent, false);
                viewHolder = new ViewHolder(convertView);
                convertView.setTag(R.id.viewHolder, (Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag(R.id.viewHolder);
            }
            ActionItem item = this.mItems.get(position);
            boolean modelAccepted = true;
            if (this.mShowNonAcceptedActions) {
                modelAccepted = item.action.isModelAccepted(this.mModel);
                viewHolder.itemView.setEnabled(modelAccepted);
            }
            String label = item.titleProvider.getTitle(context, this.mModel);
            viewHolder.textView.setText((CharSequence)label);
            if (item.iconProvider != null) {
                Drawable icon = item.iconProvider.getIconDrawable(context, this.mModel);
                if (icon != null) {
                    viewHolder.imageView.setVisibility(0);
                    viewHolder.imageView.setImageDrawable(icon);
                    if (this.mShowNonAcceptedActions) {
                        viewHolder.imageView.setAlpha(modelAccepted ? 1.0f : 0.3f);
                    }
                } else {
                    viewHolder.imageView.setVisibility(this.mHasIcons ? 4 : 8);
                }
            } else {
                viewHolder.imageView.setVisibility(this.mHasIcons ? 4 : 8);
            }
            return convertView;
        }

        public int getCount() {
            return this.mItems != null ? this.mItems.size() : 0;
        }

        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        public boolean hasStableIds() {
            return true;
        }

        public long getItemId(int position) {
            return position;
        }

        private static class ViewHolder {
            final View itemView;
            final TextView textView;
            final ImageView imageView;

            public ViewHolder(View itemView) {
                this.itemView = itemView;
                this.textView = (TextView)itemView.findViewById(16908308);
                this.imageView = (ImageView)itemView.findViewById(16908294);
            }
        }
    }

    public static class SimpleIconProvider<M>
    implements IconProvider<M> {
        private final int mIconResId;
        private final int mIconTintResId;

        public SimpleIconProvider(int iconResId, int iconTintResId) {
            this.mIconResId = iconResId;
            this.mIconTintResId = iconTintResId;
        }

        @Override
        public Drawable getIconDrawable(Context context, M model) {
            if (this.mIconResId != 0) {
                Drawable drawable = ContextCompat.getDrawable((Context)context, (int)this.mIconResId);
                if (drawable != null) {
                    drawable = DrawableCompat.wrap((Drawable)drawable.mutate());
                    if (this.mIconTintResId != 0) {
                        DrawableCompat.setTint((Drawable)drawable, (int)ContextCompat.getColor((Context)context, (int)this.mIconTintResId));
                    }
                }
                return drawable;
            }
            return null;
        }
    }

    public static class SimpleTitleProvider<M>
    implements TitleProvider<M> {
        private final int mTitleResId;

        public SimpleTitleProvider(int titleResId) {
            this.mTitleResId = titleResId;
        }

        @Override
        public String getTitle(Context context, M model) {
            return this.mTitleResId == 0 ? null : context.getString(this.mTitleResId);
        }
    }

    public static interface IconProvider<M> {
        public Drawable getIconDrawable(Context var1, M var2);
    }

    public static interface TitleProvider<M> {
        public String getTitle(Context var1, M var2);
    }

    public static class ActionItem<M> {
        public final TitleProvider<M> titleProvider;
        public final IconProvider<M> iconProvider;
        public final String actionType;
        public final Action action;

        public ActionItem(String actionType, Action action, @StringRes int menuItemTitleResId) {
            this(actionType, action, null, new SimpleTitleProvider(menuItemTitleResId));
        }

        public ActionItem(String actionType, Action action, @DrawableRes int iconResId, @ColorRes int iconTintColorResId, @StringRes int menuItemTitleResId) {
            this(actionType, action, iconResId == 0 ? null : new SimpleIconProvider(iconResId, iconTintColorResId), new SimpleTitleProvider(menuItemTitleResId));
        }

        public ActionItem(String actionType, Action action, TitleProvider<M> titleProvider) {
            this(actionType, action, null, titleProvider);
        }

        public ActionItem(String actionType, Action action, @DrawableRes int iconResId, @ColorRes int iconTintColorResId, TitleProvider<M> titleProvider) {
            this(actionType, action, iconResId == 0 ? null : new SimpleIconProvider(iconResId, iconTintColorResId), titleProvider);
        }

        public ActionItem(String actionType, Action action, IconProvider<M> iconProvider, TitleProvider<M> titleProvider) {
            this.iconProvider = iconProvider;
            this.actionType = actionType;
            this.action = action;
            this.titleProvider = titleProvider;
        }
    }
}

