/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.action;

import android.content.Context;
import android.view.View;
import com.drextended.actionhandler.action.Action;
import com.drextended.actionhandler.listener.ActionFireInterceptor;
import com.drextended.actionhandler.listener.OnActionDismissListener;
import com.drextended.actionhandler.listener.OnActionErrorListener;
import com.drextended.actionhandler.listener.OnActionFiredListener;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseAction<M>
implements Action<M> {
    protected Set<OnActionFiredListener> mActionFiredListeners = new HashSet<OnActionFiredListener>(1);
    protected Set<OnActionErrorListener> mActionErrorListeners = new HashSet<OnActionErrorListener>(1);
    protected Set<OnActionDismissListener> mActionDismissListeners = new HashSet<OnActionDismissListener>(1);
    protected Set<ActionFireInterceptor> mActionFireInterceptors = new HashSet<ActionFireInterceptor>(1);

    public void addActionFiredListener(OnActionFiredListener listener) {
        if (listener != null) {
            this.mActionFiredListeners.add(listener);
        }
    }

    public void removeActionFireListener(OnActionFiredListener listener) {
        if (listener != null) {
            this.mActionFiredListeners.remove(listener);
        }
    }

    public void removeAllActionFireListeners() {
        this.mActionFiredListeners.clear();
    }

    public void addActionErrorListener(OnActionErrorListener listener) {
        if (listener != null) {
            this.mActionErrorListeners.add(listener);
        }
    }

    public void removeActionErrorListener(OnActionErrorListener listener) {
        if (listener != null) {
            this.mActionErrorListeners.remove(listener);
        }
    }

    public void removeAllActionErrorListeners() {
        this.mActionErrorListeners.clear();
    }

    public void addActionDismissListener(OnActionDismissListener listener) {
        if (listener != null) {
            this.mActionDismissListeners.add(listener);
        }
    }

    public void removeActionDismissListener(OnActionDismissListener listener) {
        if (listener != null) {
            this.mActionDismissListeners.remove(listener);
        }
    }

    public void removeAllActionDismissListeners() {
        this.mActionDismissListeners.clear();
    }

    public void addActionFireInterceptor(ActionFireInterceptor interceptor) {
        if (interceptor != null) {
            this.mActionFireInterceptors.add(interceptor);
        }
    }

    public void removeActionFireInterceptor(ActionFireInterceptor interceptor) {
        if (interceptor != null) {
            this.mActionFireInterceptors.remove(interceptor);
        }
    }

    public void removeAllActionFireInterceptors() {
        this.mActionFireInterceptors.clear();
    }

    public void removeAllActionListeners() {
        this.mActionFiredListeners.clear();
        this.mActionErrorListeners.clear();
        this.mActionDismissListeners.clear();
        this.mActionFireInterceptors.clear();
    }

    public void notifyOnActionFired(View view, String actionType, Object model) {
        this.notifyOnActionFired(view, actionType, model, null);
    }

    public void notifyOnActionFired(View view, String actionType, Object model, Object result) {
        for (OnActionFiredListener listener : this.mActionFiredListeners) {
            listener.onActionFired(view, actionType, model, result);
        }
    }

    public void notifyOnActionError(Throwable throwable, View view, String actionType, Object model) {
        for (OnActionErrorListener listener : this.mActionErrorListeners) {
            listener.onActionError(throwable, view, actionType, model);
        }
    }

    public void notifyOnActionDismiss(String reason, View view, String actionType, Object model) {
        for (OnActionDismissListener listener : this.mActionDismissListeners) {
            listener.onActionDismiss(reason, view, actionType, model);
        }
    }

    protected boolean interceptActionFire(Context context, View view, String actionType, Object model, Action action) {
        if (this.mActionFireInterceptors != null) {
            for (ActionFireInterceptor interceptor : this.mActionFireInterceptors) {
                if (!interceptor.onInterceptActionFire(context, view, actionType, model, action)) continue;
                return true;
            }
        }
        return false;
    }
}

