/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.drextended.actionhandler.action.Action;
import com.drextended.actionhandler.action.BaseAction;
import com.drextended.actionhandler.action.Cancelable;
import com.drextended.actionhandler.listener.ActionClickListener;
import com.drextended.actionhandler.listener.ActionFireInterceptor;
import com.drextended.actionhandler.listener.ActionInterceptor;
import com.drextended.actionhandler.listener.OnActionDismissListener;
import com.drextended.actionhandler.listener.OnActionErrorListener;
import com.drextended.actionhandler.listener.OnActionFiredListener;
import com.drextended.actionhandler.util.DebounceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActionHandler
implements ActionClickListener,
OnActionFiredListener,
OnActionErrorListener,
OnActionDismissListener,
ActionFireInterceptor {
    protected final List<ActionPair> mActions;
    protected Set<OnActionFiredListener> mOnActionFiredListeners;
    protected Set<OnActionErrorListener> mOnActionErrorListeners;
    protected Set<OnActionDismissListener> mOnActionDismissListeners;
    protected Set<ActionFireInterceptor> mActionFireInterceptors;
    private Set<ActionInterceptor> mActionInterceptors;
    private Map<String, Long> mActionDebounceTime;
    private long mDefaultDebounceTime = 0L;
    private DebounceHelper mDebounceHelper;

    protected ActionHandler(List<ActionPair> actions) {
        this.mActions = actions != null ? actions : Collections.emptyList();
        for (ActionPair actionPair : this.mActions) {
            if (!(actionPair.action instanceof BaseAction)) continue;
            BaseAction baseAction = (BaseAction)actionPair.action;
            baseAction.addActionFiredListener(this);
            baseAction.addActionErrorListener(this);
            baseAction.addActionDismissListener(this);
            baseAction.addActionFireInterceptor(this);
        }
    }

    @Deprecated
    public void setOnActionFiredListener(OnActionFiredListener actionFiredListener) {
        if (actionFiredListener != null) {
            this.removeAllActionFiredListeners();
            this.addActionFiredListener(actionFiredListener);
        } else {
            this.removeAllActionFiredListeners();
        }
    }

    public void addActionFiredListener(OnActionFiredListener actionFiredListener) {
        if (this.mOnActionFiredListeners == null) {
            this.mOnActionFiredListeners = new HashSet<OnActionFiredListener>(1);
        }
        this.mOnActionFiredListeners.add(actionFiredListener);
    }

    public void removeActionFiredListener(OnActionFiredListener actionFiredListener) {
        if (this.mOnActionFiredListeners != null) {
            this.mOnActionFiredListeners.remove(actionFiredListener);
        }
    }

    public void removeAllActionFiredListeners() {
        if (this.mOnActionFiredListeners != null) {
            this.mOnActionFiredListeners.clear();
        }
    }

    public void addActionErrorListener(OnActionErrorListener actionErrorListener) {
        if (this.mOnActionErrorListeners == null) {
            this.mOnActionErrorListeners = new HashSet<OnActionErrorListener>(1);
        }
        this.mOnActionErrorListeners.add(actionErrorListener);
    }

    public void removeActionErrorListener(OnActionErrorListener actionErrorListener) {
        if (this.mOnActionErrorListeners != null) {
            this.mOnActionErrorListeners.remove(actionErrorListener);
        }
    }

    public void removeAllActionErrorListeners() {
        if (this.mOnActionErrorListeners != null) {
            this.mOnActionErrorListeners.clear();
        }
    }

    public void addActionDismissListener(OnActionDismissListener listener) {
        if (this.mOnActionDismissListeners == null) {
            this.mOnActionDismissListeners = new HashSet<OnActionDismissListener>(1);
        }
        this.mOnActionDismissListeners.add(listener);
    }

    public void removeActionDismissListener(OnActionDismissListener listener) {
        if (this.mOnActionDismissListeners != null) {
            this.mOnActionDismissListeners.remove(listener);
        }
    }

    public void removeAllActionDismissListeners() {
        if (this.mOnActionDismissListeners != null) {
            this.mOnActionDismissListeners.clear();
        }
    }

    @Deprecated
    public void setActionInterceptor(ActionInterceptor actionInterceptor) {
        if (actionInterceptor != null) {
            this.removeAllActionInterceptors();
            this.addActionInterceptor(actionInterceptor);
        } else {
            this.removeAllActionInterceptors();
        }
    }

    public void addActionInterceptor(ActionInterceptor actionInterceptor) {
        if (this.mActionInterceptors == null) {
            this.mActionInterceptors = new HashSet<ActionInterceptor>(1);
        }
        this.mActionInterceptors.add(actionInterceptor);
    }

    public void removeActionInterceptor(ActionInterceptor actionInterceptor) {
        if (this.mActionInterceptors != null) {
            this.mActionInterceptors.remove(actionInterceptor);
        }
    }

    public void removeAllActionInterceptors() {
        if (this.mActionInterceptors != null) {
            this.mActionInterceptors.clear();
        }
    }

    public void addActionFireInterceptor(ActionFireInterceptor actionFireInterceptor) {
        if (this.mActionFireInterceptors == null) {
            this.mActionFireInterceptors = new HashSet<ActionFireInterceptor>(1);
        }
        this.mActionFireInterceptors.add(actionFireInterceptor);
    }

    public void removeActionFireInterceptor(ActionFireInterceptor actionFireInterceptor) {
        if (this.mActionFireInterceptors != null) {
            this.mActionFireInterceptors.remove(actionFireInterceptor);
        }
    }

    public void removeAllActionFireInterceptors() {
        if (this.mActionFireInterceptors != null) {
            this.mActionFireInterceptors.clear();
        }
    }

    public void removeAllActionListeners() {
        this.removeAllActionFiredListeners();
        this.removeAllActionDismissListeners();
        this.removeAllActionInterceptors();
        this.removeAllActionFireInterceptors();
        this.removeAllActionErrorListeners();
    }

    @Override
    public void onActionFired(View view, String actionType, Object model, Object result) {
        if (this.mOnActionFiredListeners != null) {
            for (OnActionFiredListener listener : this.mOnActionFiredListeners) {
                listener.onActionFired(view, actionType, model, result);
            }
        }
    }

    @Override
    public void onActionError(Throwable throwable, View view, String actionType, Object model) {
        if (this.mOnActionErrorListeners != null) {
            for (OnActionErrorListener listener : this.mOnActionErrorListeners) {
                listener.onActionError(throwable, view, actionType, model);
            }
        }
    }

    @Override
    public void onActionDismiss(String reason, View view, String actionType, Object model) {
        if (this.mOnActionDismissListeners != null) {
            for (OnActionDismissListener listener : this.mOnActionDismissListeners) {
                listener.onActionDismiss(reason, view, actionType, model);
            }
        }
    }

    @Override
    public boolean onInterceptActionFire(Context context, View view, String actionType, Object model, Action action) {
        return this.interceptActionFire(context, view, actionType, model, action);
    }

    public boolean canHandle(String actionType) {
        for (ActionPair actionPair : this.mActions) {
            if (!ActionHandler.equals(actionType, actionPair.actionType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onActionClick(View view, String actionType, Object model) {
        if (view == null) {
            return;
        }
        Context context = view.getContext();
        this.fireAction(context, view, actionType, model);
    }

    public void fireAction(Context context, View view, String actionType, Object model) {
        if (!this.checkDebounceTimeElapsed(actionType)) {
            Log.d((String)"ActionHandler", (String)"Debounce time not elapsed. Action intercepted!");
            return;
        }
        if (this.mActionInterceptors != null) {
            for (ActionInterceptor interceptor : this.mActionInterceptors) {
                if (!interceptor.onInterceptAction(context, view, actionType, model)) continue;
                return;
            }
        }
        for (ActionPair actionPair : this.mActions) {
            Action action;
            if (actionPair.actionType != null && !actionPair.actionType.equals(actionType) || (action = actionPair.action) == null || !action.isModelAccepted(model) || this.interceptActionFire(context, view, actionType, model, action)) continue;
            action.onFireAction(context, view, actionType, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDebounceTimeElapsed(String actionType) {
        if (this.mDefaultDebounceTime > 0L || this.mActionDebounceTime != null) {
            Long debounceMillis;
            if (this.mDebounceHelper == null) {
                ActionHandler actionHandler = this;
                synchronized (actionHandler) {
                    if (this.mDebounceHelper == null) {
                        this.mDebounceHelper = new DebounceHelper();
                    }
                }
            }
            Long l = debounceMillis = this.mActionDebounceTime == null ? null : this.mActionDebounceTime.get(actionType);
            if (debounceMillis == null) {
                debounceMillis = this.mDefaultDebounceTime;
            }
            return debounceMillis <= 0L || this.mDebounceHelper.checkTimeAndResetIfElapsed(actionType, debounceMillis);
        }
        return true;
    }

    private boolean interceptActionFire(Context context, View view, String actionType, Object model, Action action) {
        if (this.mActionFireInterceptors != null) {
            for (ActionFireInterceptor interceptor : this.mActionFireInterceptors) {
                if (!interceptor.onInterceptActionFire(context, view, actionType, model, action)) continue;
                return true;
            }
        }
        return false;
    }

    public final void cancelAll() {
        for (ActionPair actionPair : this.mActions) {
            if (!(actionPair.action instanceof Cancelable)) continue;
            ((Cancelable)((Object)actionPair.action)).cancel();
        }
    }

    public static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static class ActionPair {
        public String actionType;
        public Action action;

        public ActionPair(String actionType, Action action) {
            this.actionType = actionType;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionPair that = (ActionPair)o;
            if (this.actionType != null ? !this.actionType.equals(that.actionType) : that.actionType != null) {
                return false;
            }
            return this.action != null ? this.action.equals(that.action) : that.action == null;
        }

        public int hashCode() {
            int result = this.actionType != null ? this.actionType.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ActionPair{actionType='" + this.actionType + '\'' + ", action=" + this.action + '}';
        }
    }

    public static final class Builder {
        private List<ActionPair> mActions = new ArrayList<ActionPair>();
        private Set<OnActionFiredListener> mActionFiredListeners;
        private Set<OnActionErrorListener> mActionErrorListeners;
        private Set<OnActionDismissListener> mActionDismissListeners;
        private Set<ActionInterceptor> mActionInterceptors;
        private Set<ActionFireInterceptor> mActionFireInterceptors;
        private Map<String, Long> mActionDebounceTime;
        private long mDefaultDebounceTime = 0L;

        public Builder addAction(String actionType, Action action) {
            this.mActions.add(new ActionPair(actionType, action));
            return this;
        }

        @Deprecated
        public Builder setActionFiredListener(OnActionFiredListener actionFiredListener) {
            this.addActionFiredListener(actionFiredListener);
            return this;
        }

        public Builder addActionFiredListener(OnActionFiredListener actionFiredListener) {
            if (this.mActionFiredListeners == null) {
                this.mActionFiredListeners = new HashSet<OnActionFiredListener>(1);
            }
            this.mActionFiredListeners.add(actionFiredListener);
            return this;
        }

        public Builder addActionErrorListener(OnActionErrorListener actionErrorListener) {
            if (this.mActionErrorListeners == null) {
                this.mActionErrorListeners = new HashSet<OnActionErrorListener>(1);
            }
            this.mActionErrorListeners.add(actionErrorListener);
            return this;
        }

        public Builder addActionDismissListener(OnActionDismissListener listener) {
            if (this.mActionDismissListeners == null) {
                this.mActionDismissListeners = new HashSet<OnActionDismissListener>(1);
            }
            this.mActionDismissListeners.add(listener);
            return this;
        }

        public Builder setActionInterceptor(ActionInterceptor actionInterceptor) {
            this.addActionInterceptor(actionInterceptor);
            return this;
        }

        public Builder addActionInterceptor(ActionInterceptor actionInterceptor) {
            if (this.mActionInterceptors == null) {
                this.mActionInterceptors = new HashSet<ActionInterceptor>(1);
            }
            this.mActionInterceptors.add(actionInterceptor);
            return this;
        }

        public Builder addActionFireInterceptor(ActionFireInterceptor actionFireInterceptor) {
            if (this.mActionFireInterceptors == null) {
                this.mActionFireInterceptors = new HashSet<ActionFireInterceptor>(1);
            }
            this.mActionFireInterceptors.add(actionFireInterceptor);
            return this;
        }

        public Builder setDefaultDebounce(long debounceTimeMillis) {
            this.mDefaultDebounceTime = debounceTimeMillis > 0L ? debounceTimeMillis : 0L;
            return this;
        }

        public Builder setDebounce(long debounceTimeMillis, String ... actionTypes) {
            if (actionTypes != null && actionTypes.length > 0) {
                if (this.mActionDebounceTime == null) {
                    this.mActionDebounceTime = new HashMap<String, Long>();
                }
                for (String actionType : actionTypes) {
                    this.mActionDebounceTime.put(actionType, debounceTimeMillis);
                }
            }
            return this;
        }

        public ActionHandler build() {
            ActionHandler actionHandler = new ActionHandler(this.mActions);
            actionHandler.mDefaultDebounceTime = this.mDefaultDebounceTime;
            actionHandler.mActionDebounceTime = this.mActionDebounceTime;
            if (this.mActionFiredListeners != null) {
                actionHandler.mOnActionFiredListeners = this.mActionFiredListeners;
            }
            if (this.mActionErrorListeners != null) {
                actionHandler.mOnActionErrorListeners = this.mActionErrorListeners;
            }
            if (this.mActionDismissListeners != null) {
                actionHandler.mOnActionDismissListeners = this.mActionDismissListeners;
            }
            if (this.mActionInterceptors != null && this.mActionInterceptors.size() > 0) {
                actionHandler.mActionInterceptors = this.mActionInterceptors;
            }
            if (this.mActionFireInterceptors != null && this.mActionFireInterceptors.size() > 0) {
                actionHandler.mActionFireInterceptors = this.mActionFireInterceptors;
            }
            return actionHandler;
        }
    }
}

