/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.PathExtendedElement;
import com.docusign.esign.model.PropertyMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information for transfering values between Salesforce data fields and DocuSign Tabs.")
public class MergeField {
    @JsonProperty(value="allowSenderToEdit")
    private String allowSenderToEdit = null;
    @JsonProperty(value="allowSenderToEditMetadata")
    private PropertyMetadata allowSenderToEditMetadata = null;
    @JsonProperty(value="configurationType")
    private String configurationType = null;
    @JsonProperty(value="configurationTypeMetadata")
    private PropertyMetadata configurationTypeMetadata = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="pathExtended")
    private List<PathExtendedElement> pathExtended = null;
    @JsonProperty(value="pathExtendedMetadata")
    private PropertyMetadata pathExtendedMetadata = null;
    @JsonProperty(value="pathMetadata")
    private PropertyMetadata pathMetadata = null;
    @JsonProperty(value="row")
    private String row = null;
    @JsonProperty(value="rowMetadata")
    private PropertyMetadata rowMetadata = null;
    @JsonProperty(value="writeBack")
    private String writeBack = null;
    @JsonProperty(value="writeBackMetadata")
    private PropertyMetadata writeBackMetadata = null;

    public MergeField allowSenderToEdit(String allowSenderToEdit) {
        this.allowSenderToEdit = allowSenderToEdit;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, the sender can modify the value of the custom tab during the sending process.")
    public String getAllowSenderToEdit() {
        return this.allowSenderToEdit;
    }

    public void setAllowSenderToEdit(String allowSenderToEdit) {
        this.allowSenderToEdit = allowSenderToEdit;
    }

    public MergeField allowSenderToEditMetadata(PropertyMetadata allowSenderToEditMetadata) {
        this.allowSenderToEditMetadata = allowSenderToEditMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getAllowSenderToEditMetadata() {
        return this.allowSenderToEditMetadata;
    }

    public void setAllowSenderToEditMetadata(PropertyMetadata allowSenderToEditMetadata) {
        this.allowSenderToEditMetadata = allowSenderToEditMetadata;
    }

    public MergeField configurationType(String configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    @ApiModelProperty(value="If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.")
    public String getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    public MergeField configurationTypeMetadata(PropertyMetadata configurationTypeMetadata) {
        this.configurationTypeMetadata = configurationTypeMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getConfigurationTypeMetadata() {
        return this.configurationTypeMetadata;
    }

    public void setConfigurationTypeMetadata(PropertyMetadata configurationTypeMetadata) {
        this.configurationTypeMetadata = configurationTypeMetadata;
    }

    public MergeField path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Sets the object associated with the custom tab. Currently this is the Salesforce Object.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public MergeField pathExtended(List<PathExtendedElement> pathExtended) {
        this.pathExtended = pathExtended;
        return this;
    }

    public MergeField addPathExtendedItem(PathExtendedElement pathExtendedItem) {
        if (this.pathExtended == null) {
            this.pathExtended = new ArrayList<PathExtendedElement>();
        }
        this.pathExtended.add(pathExtendedItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<PathExtendedElement> getPathExtended() {
        return this.pathExtended;
    }

    public void setPathExtended(List<PathExtendedElement> pathExtended) {
        this.pathExtended = pathExtended;
    }

    public MergeField pathExtendedMetadata(PropertyMetadata pathExtendedMetadata) {
        this.pathExtendedMetadata = pathExtendedMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getPathExtendedMetadata() {
        return this.pathExtendedMetadata;
    }

    public void setPathExtendedMetadata(PropertyMetadata pathExtendedMetadata) {
        this.pathExtendedMetadata = pathExtendedMetadata;
    }

    public MergeField pathMetadata(PropertyMetadata pathMetadata) {
        this.pathMetadata = pathMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getPathMetadata() {
        return this.pathMetadata;
    }

    public void setPathMetadata(PropertyMetadata pathMetadata) {
        this.pathMetadata = pathMetadata;
    }

    public MergeField row(String row) {
        this.row = row;
        return this;
    }

    @ApiModelProperty(value="Specifies the row number in a Salesforce table that the merge field value corresponds to.")
    public String getRow() {
        return this.row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public MergeField rowMetadata(PropertyMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    public void setRowMetadata(PropertyMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
    }

    public MergeField writeBack(String writeBack) {
        this.writeBack = writeBack;
        return this;
    }

    @ApiModelProperty(value="When wet to true, the information entered in the tab automatically updates the related Salesforce data when an envelope is completed.")
    public String getWriteBack() {
        return this.writeBack;
    }

    public void setWriteBack(String writeBack) {
        this.writeBack = writeBack;
    }

    public MergeField writeBackMetadata(PropertyMetadata writeBackMetadata) {
        this.writeBackMetadata = writeBackMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getWriteBackMetadata() {
        return this.writeBackMetadata;
    }

    public void setWriteBackMetadata(PropertyMetadata writeBackMetadata) {
        this.writeBackMetadata = writeBackMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeField mergeField = (MergeField)o;
        return Objects.equals(this.allowSenderToEdit, mergeField.allowSenderToEdit) && Objects.equals(this.allowSenderToEditMetadata, mergeField.allowSenderToEditMetadata) && Objects.equals(this.configurationType, mergeField.configurationType) && Objects.equals(this.configurationTypeMetadata, mergeField.configurationTypeMetadata) && Objects.equals(this.path, mergeField.path) && Objects.equals(this.pathExtended, mergeField.pathExtended) && Objects.equals(this.pathExtendedMetadata, mergeField.pathExtendedMetadata) && Objects.equals(this.pathMetadata, mergeField.pathMetadata) && Objects.equals(this.row, mergeField.row) && Objects.equals(this.rowMetadata, mergeField.rowMetadata) && Objects.equals(this.writeBack, mergeField.writeBack) && Objects.equals(this.writeBackMetadata, mergeField.writeBackMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.allowSenderToEdit, this.allowSenderToEditMetadata, this.configurationType, this.configurationTypeMetadata, this.path, this.pathExtended, this.pathExtendedMetadata, this.pathMetadata, this.row, this.rowMetadata, this.writeBack, this.writeBackMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MergeField {\n");
        sb.append("    allowSenderToEdit: ").append(this.toIndentedString(this.allowSenderToEdit)).append("\n");
        sb.append("    allowSenderToEditMetadata: ").append(this.toIndentedString(this.allowSenderToEditMetadata)).append("\n");
        sb.append("    configurationType: ").append(this.toIndentedString(this.configurationType)).append("\n");
        sb.append("    configurationTypeMetadata: ").append(this.toIndentedString(this.configurationTypeMetadata)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    pathExtended: ").append(this.toIndentedString(this.pathExtended)).append("\n");
        sb.append("    pathExtendedMetadata: ").append(this.toIndentedString(this.pathExtendedMetadata)).append("\n");
        sb.append("    pathMetadata: ").append(this.toIndentedString(this.pathMetadata)).append("\n");
        sb.append("    row: ").append(this.toIndentedString(this.row)).append("\n");
        sb.append("    rowMetadata: ").append(this.toIndentedString(this.rowMetadata)).append("\n");
        sb.append("    writeBack: ").append(this.toIndentedString(this.writeBack)).append("\n");
        sb.append("    writeBackMetadata: ").append(this.toIndentedString(this.writeBackMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

