/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The object of data to be merged with the clickwrap document. A merged document must be created from Click's web editor and supports fullName, email, company, title and date.")
public class DocumentData {
    @JsonProperty(value="fullName")
    private String fullName = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="company")
    private String company = null;
    @JsonProperty(value="jobTitle")
    private String jobTitle = null;
    @JsonProperty(value="date")
    private String date = null;

    public DocumentData fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Schema(description="The full name of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public DocumentData email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="The email address of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public DocumentData company(String company) {
        this.company = company;
        return this;
    }

    @Schema(description="The company name of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public DocumentData jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @Schema(description="The job title of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.")
    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public DocumentData date(String date) {
        this.date = date;
        return this;
    }

    @Schema(description="A custom date for the contract. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentData documentData = (DocumentData)o;
        return Objects.equals(this.fullName, documentData.fullName) && Objects.equals(this.email, documentData.email) && Objects.equals(this.company, documentData.company) && Objects.equals(this.jobTitle, documentData.jobTitle) && Objects.equals(this.date, documentData.date);
    }

    public int hashCode() {
        return Objects.hash(this.fullName, this.email, this.company, this.jobTitle, this.date);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentData {\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

