/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion;

import com.documents4j.conversion.IExternalConverter;
import com.documents4j.throwables.ConverterAccessException;
import com.documents4j.util.OsUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.ToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public abstract class AbstractExternalConverter
implements IExternalConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long processTimeout;
    private final File baseFolder;

    public AbstractExternalConverter(File baseFolder, long processTimeout, TimeUnit processTimeoutUnit) {
        this.baseFolder = baseFolder;
        this.processTimeout = processTimeoutUnit.toMillis(processTimeout);
    }

    protected static String quote(String ... args) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append('\"').append(arg.replace("\"", "\"\"")).append('\"');
        }
        return stringBuilder.toString();
    }

    protected static String doubleQuote(String ... args) {
        return "\"" + AbstractExternalConverter.quote(args) + "\"";
    }

    protected File getBaseFolder() {
        return this.baseFolder;
    }

    protected long getProcessTimeout() {
        return this.processTimeout;
    }

    protected ProcessExecutor makePresetProcessExecutor() {
        return this.makePresetProcessExecutor((OutputStream)Slf4jStream.of((Logger)this.logger).asInfo());
    }

    protected ProcessExecutor makePresetProcessExecutor(OutputStream outputStream) {
        return new ProcessExecutor().redirectOutput(outputStream).redirectError((OutputStream)Slf4jStream.of((Logger)this.logger).asInfo()).readOutput(true).directory(this.getBaseFolder()).timeout(this.getProcessTimeout(), TimeUnit.MILLISECONDS).exitValueAny();
    }

    protected int runNoArgumentScript(File script) {
        this.logger.trace("Execute no-argument script {}", (Object)script);
        try {
            String[] command = null;
            int exitCode = -100;
            if (OsUtils.isWindows()) {
                command = new String[]{"cmd", "/S", "/C", AbstractExternalConverter.doubleQuote(script.getAbsolutePath())};
                exitCode = this.makePresetProcessExecutor().command(command).execute().getExitValue();
            } else if (OsUtils.isMac()) {
                command = new String[]{"/usr/bin/osascript", script.getAbsolutePath()};
                ProcessResult res = this.makePresetProcessExecutor().command(command).execute();
                ToIntFunction<ProcessResult> extractor = result -> Integer.parseInt(new String(result.output(), StandardCharsets.UTF_8).replaceAll("\\n", ""));
                exitCode = extractor.applyAsInt(res);
            }
            this.logger.trace("Got exitcode {} for command {}", (Object)exitCode, (Object)Arrays.toString(command));
            return exitCode;
        }
        catch (IOException e) {
            String message = String.format("Unable to run script: %s", script);
            this.logger.error(message, (Throwable)e);
            throw new ConverterAccessException(message, (Throwable)e);
        }
        catch (InterruptedException e) {
            String message = String.format("Thread responsible for running script was interrupted: %s", script);
            this.logger.error(message, (Throwable)e);
            throw new ConverterAccessException(message, (Throwable)e);
        }
        catch (TimeoutException e) {
            String message = String.format("Thread responsible for running script timed out: %s", script);
            this.logger.error(message, (Throwable)e);
            throw new ConverterAccessException(message, (Throwable)e);
        }
    }

    protected void tryDelete(File file) {
        if (!file.delete()) {
            this.logger.warn("Cannot delete file: {}", (Object)file);
        }
    }
}

