/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.adapter;

import com.documents4j.api.IFileSource;
import com.documents4j.api.IInputStreamSource;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.Objects;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class InputStreamSourceFromFileSource
implements IInputStreamSource {
    private final IFileSource fileSource;
    private volatile File file;

    public InputStreamSourceFromFileSource(IFileSource fileSource) {
        this.fileSource = fileSource;
    }

    public InputStream getInputStream() {
        this.file = this.fileSource.getFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            throw new FileSystemInteractionException(String.format("Could not find file %s", this.file), (Throwable)e);
        }
        catch (IOException e) {
            throw new FileSystemInteractionException(String.format("Could not read file %s", this.file), (Throwable)e);
        }
    }

    public void onConsumed(InputStream inputStream) {
        try {
            this.close(inputStream);
        }
        finally {
            this.fileSource.onConsumed(this.file);
        }
    }

    private void close(InputStream inputStream) {
        try {
            Closeables.close((Closeable)inputStream, (boolean)false);
        }
        catch (IOException e) {
            throw new FileSystemInteractionException(String.format("Could not close stream for file %s", this.file), (Throwable)e);
        }
    }

    public String toString() {
        return Objects.toStringHelper(InputStreamSourceFromFileSource.class).add("file", (Object)this.file).add("fileSource", (Object)this.fileSource).toString();
    }
}

