/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.adapter;

import com.documents4j.adapter.FileSourceFromFile;
import com.documents4j.adapter.FileSourceFromInputStreamSource;
import com.documents4j.adapter.InputStreamSourceFromFileSource;
import com.documents4j.adapter.InputStreamSourceFromInputStream;
import com.documents4j.api.IConversionJobWithSourceUnspecified;
import com.documents4j.api.IConverter;
import com.documents4j.api.IFileSource;
import com.documents4j.api.IInputStreamSource;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConverterAdapter
implements IConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConverterAdapter.class);
    private static final String NO_EXTENSION = "";
    private static final String TEMP_FILE_PREFIX = "temp";
    private final File tempFileFolder;
    private final AtomicLong uniqueNameMaker;
    private final Thread shutDownHook;

    protected ConverterAdapter(File tempFileFolder) {
        this.tempFileFolder = ConverterAdapter.makeTemporaryFolder(tempFileFolder);
        this.uniqueNameMaker = new AtomicLong(1L);
        this.shutDownHook = new ConverterShutdownHook();
        this.registerShutdownHook();
    }

    protected static ExecutorService makeExecutorService(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>());
    }

    private static File makeTemporaryFolder(File baseFolder) {
        File tempFileFolder = new File(baseFolder, UUID.randomUUID().toString());
        Preconditions.checkState((boolean)tempFileFolder.mkdir(), (Object)String.format("Cannot create folder: %s", tempFileFolder));
        return tempFileFolder;
    }

    private static void deleteOrLog(File file) {
        if (!file.delete()) {
            LOGGER.warn("Could not delete temporary folder: {}", (Object)file);
        }
    }

    public IConversionJobWithSourceUnspecified convert(File source) {
        return this.convert(new FileSourceFromFile(source));
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source) {
        return this.convert(source, true);
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source, boolean close) {
        return this.convert(new InputStreamSourceFromInputStream(source, close));
    }

    public IConversionJobWithSourceUnspecified convert(IFileSource source) {
        return this.convert(new InputStreamSourceFromFileSource(source));
    }

    public IConversionJobWithSourceUnspecified convert(IInputStreamSource source) {
        return this.convert(new FileSourceFromInputStreamSource(source, this.makeTemporaryFile()));
    }

    protected File makeTemporaryFile() {
        return this.makeTemporaryFile(NO_EXTENSION);
    }

    public File getTempFileFolder() {
        return this.tempFileFolder;
    }

    protected File makeTemporaryFile(String suffix) {
        return new File(this.tempFileFolder, String.format("%s%d%s", TEMP_FILE_PREFIX, this.uniqueNameMaker.getAndIncrement(), suffix));
    }

    public void shutDown() {
        this.deregisterShutdownHook();
        ConverterAdapter.deleteOrLog(this.tempFileFolder);
    }

    protected void registerShutdownHook() {
        try {
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
        catch (IllegalStateException e) {
            LOGGER.info("Tried to register shut down hook in shut down period", (Throwable)e);
        }
    }

    protected void deregisterShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
        }
        catch (IllegalStateException e) {
            LOGGER.info("Tried to deregister shut down hook in shut down period", (Throwable)e);
        }
    }

    private class ConverterShutdownHook
    extends Thread {
        public ConverterShutdownHook() {
            super(String.format("Shutdown hook: %s", ConverterAdapter.this.getClass().getName()));
        }

        @Override
        public void run() {
            ConverterAdapter.this.shutDown();
        }
    }
}

