/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.adapter.ConversionJobAdapter;
import com.documents4j.adapter.ConversionJobWithSourceSpecifiedAdapter;
import com.documents4j.adapter.ConverterAdapter;
import com.documents4j.api.DocumentType;
import com.documents4j.api.IConversionJob;
import com.documents4j.api.IConversionJobWithPriorityUnspecified;
import com.documents4j.api.IConversionJobWithSourceSpecified;
import com.documents4j.api.IConversionJobWithSourceUnspecified;
import com.documents4j.api.IConversionJobWithTargetUnspecified;
import com.documents4j.api.IConverter;
import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IFileSource;
import com.documents4j.builder.AbstractConverterBuilder;
import com.documents4j.conversion.DefaultConversionManager;
import com.documents4j.conversion.IConversionManager;
import com.documents4j.conversion.IExternalConverter;
import com.documents4j.job.LocalFutureWrappingPriorityFuture;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConverter
extends ConverterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConverter.class);
    private final IConversionManager conversionManager;
    private final ExecutorService executorService;

    protected LocalConverter(File baseFolder, int corePoolSize, int maximumPoolSize, long keepAliveTime, long processTimeout, TimeUnit processTimeoutUnit, Map<Class<? extends IExternalConverter>, Boolean> converterConfiguration) {
        super(baseFolder);
        this.conversionManager = this.makeConversionManager(baseFolder, processTimeout, processTimeoutUnit, converterConfiguration);
        this.executorService = LocalConverter.makeExecutorService((int)corePoolSize, (int)maximumPoolSize, (long)keepAliveTime);
        LOGGER.info("The documents4j local converter has started successfully");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static IConverter make() {
        return LocalConverter.builder().build();
    }

    protected IConversionManager makeConversionManager(File baseFolder, long processTimeout, TimeUnit unit, Map<Class<? extends IExternalConverter>, Boolean> converterConfiguration) {
        return new DefaultConversionManager(baseFolder, processTimeout, unit, converterConfiguration);
    }

    public Map<DocumentType, Set<DocumentType>> getSupportedConversions() {
        return this.conversionManager.getSupportedConversions();
    }

    public IConversionJobWithSourceUnspecified convert(IFileSource source) {
        return new LocalConversionJobWithSourceUnspecified(source);
    }

    public boolean isOperational() {
        return !this.executorService.isShutdown() && this.conversionManager.isOperational();
    }

    public void shutDown() {
        try {
            this.conversionManager.shutDown();
            this.executorService.shutdownNow();
        }
        finally {
            super.shutDown();
        }
        LOGGER.info("The documents4j local converter has shut down successfully");
    }

    private class LocalConversionJob
    extends ConversionJobAdapter
    implements IConversionJobWithPriorityUnspecified {
        private final IFileSource source;
        private final DocumentType sourceFormat;
        private final File target;
        private final IFileConsumer callback;
        private final DocumentType targetFormat;
        private final int priority;

        private LocalConversionJob(IFileSource source, DocumentType sourceFormat, File target, IFileConsumer callback, DocumentType targetFormat, int priority) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.target = target;
            this.callback = callback;
            this.targetFormat = targetFormat;
            this.priority = priority;
        }

        public Future<Boolean> schedule() {
            LocalFutureWrappingPriorityFuture job = new LocalFutureWrappingPriorityFuture(LocalConverter.this.conversionManager, this.source, this.sourceFormat, this.target, this.callback, this.targetFormat, this.priority);
            LocalConverter.this.executorService.execute((Runnable)((Object)job));
            return job;
        }

        public IConversionJob prioritizeWith(int priority) {
            return new LocalConversionJob(this.source, this.sourceFormat, this.target, this.callback, this.targetFormat, priority);
        }
    }

    private class LocalConversionJobWithTargetUnspecified
    implements IConversionJobWithTargetUnspecified {
        private final IFileSource source;
        private final DocumentType sourceFormat;
        private final File target;
        private final IFileConsumer callback;

        public LocalConversionJobWithTargetUnspecified(IFileSource source, DocumentType sourceFormat, File target, IFileConsumer callback) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.target = target;
            this.callback = callback;
        }

        public IConversionJobWithPriorityUnspecified as(DocumentType targetFormat) {
            return new LocalConversionJob(this.source, this.sourceFormat, this.target, this.callback, targetFormat, 500);
        }
    }

    private class LocalConversionJobWithSourceSpecified
    extends ConversionJobWithSourceSpecifiedAdapter {
        private final IFileSource source;
        private final DocumentType sourceFormat;

        private LocalConversionJobWithSourceSpecified(IFileSource source, DocumentType sourceFormat) {
            this.source = source;
            this.sourceFormat = sourceFormat;
        }

        public IConversionJobWithTargetUnspecified to(File target, IFileConsumer callback) {
            return new LocalConversionJobWithTargetUnspecified(this.source, this.sourceFormat, target, callback);
        }

        protected File makeTemporaryFile(String suffix) {
            return LocalConverter.this.makeTemporaryFile();
        }
    }

    private class LocalConversionJobWithSourceUnspecified
    implements IConversionJobWithSourceUnspecified {
        private final IFileSource source;

        private LocalConversionJobWithSourceUnspecified(IFileSource source) {
            this.source = source;
        }

        public IConversionJobWithSourceSpecified as(DocumentType sourceFormat) {
            return new LocalConversionJobWithSourceSpecified(this.source, sourceFormat);
        }
    }

    public static final class Builder
    extends AbstractConverterBuilder<Builder> {
        public static final long DEFAULT_PROCESS_TIME_OUT = TimeUnit.MINUTES.toMillis(5L);
        private final Map<Class<? extends IExternalConverter>, Boolean> converterConfiguration;
        private long processTimeout = DEFAULT_PROCESS_TIME_OUT;

        private Builder() {
            this.converterConfiguration = new HashMap<Class<? extends IExternalConverter>, Boolean>();
        }

        public Builder processTimeout(long processTimeout, TimeUnit timeUnit) {
            Builder.assertNumericArgument((long)processTimeout, (boolean)true);
            this.processTimeout = timeUnit.toMillis(processTimeout);
            return this;
        }

        public Builder enable(Class<? extends IExternalConverter> externalConverter) {
            this.converterConfiguration.put(externalConverter, Boolean.TRUE);
            return this;
        }

        public Builder disable(Class<? extends IExternalConverter> externalConverter) {
            this.converterConfiguration.put(externalConverter, Boolean.FALSE);
            return this;
        }

        public IConverter build() {
            return new LocalConverter(this.normalizedBaseFolder(), this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.processTimeout, TimeUnit.MILLISECONDS, this.converterConfiguration);
        }

        public long getProcessTimeout() {
            return this.processTimeout;
        }

        public Map<Class<? extends IExternalConverter>, Boolean> getConverterConfiguration() {
            return Collections.unmodifiableMap(this.converterConfiguration);
        }
    }
}

