/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.refresh;

import android.content.Context;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import com.dinuscxj.refresh.IRefreshStatus;
import com.dinuscxj.refresh.RefreshView;

public class RecyclerRefreshLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final int INVALID_INDEX = -1;
    private static final int INVALID_POINTER = -1;
    private static final int DEFAULT_REFRESH_SIZE_DP = 30;
    private static final int DEFAULT_ANIMATE_DURATION = 200;
    private static final int DEFAULT_REFRESH_TARGET_OFFSET_DP = 50;
    private static final float DRAG_RATE = 0.5f;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private float mTotalUnconsumed;
    private final int[] mParentScrollConsumed = new int[2];
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private boolean mNotify;
    private boolean mRefreshing;
    private boolean mIsBeingDragged;
    private boolean mIsFitRefreshing;
    private boolean mReturningToStart;
    private int mRefreshViewIndex = -1;
    private int mActivePointerId = -1;
    private int mAnimateDuration = 200;
    private int mFrom;
    private int mTouchSlop;
    private int mSpinnerSize;
    private int mCurrentScrollOffset;
    private float mInitialDownY;
    private float mInitialMotionY;
    private float mRefreshTargetOffset;
    private View mTarget;
    private View mRefreshView;
    private IRefreshStatus mIRefreshStatus;
    private OnRefreshListener mOnRefreshListener;
    private Interpolator mInterpolator;
    private final Animation mAnimateToRefreshingAnimation = new Animation(){

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            int targetEnd = (int)RecyclerRefreshLayout.this.mRefreshTargetOffset;
            int targetTop = (int)((float)RecyclerRefreshLayout.this.mFrom + (float)(targetEnd - RecyclerRefreshLayout.this.mFrom) * interpolatedTime);
            RecyclerRefreshLayout.this.scrollTargetOffset(0, -RecyclerRefreshLayout.this.mCurrentScrollOffset - targetTop);
        }
    };
    private final Animation mAnimateToStartAnimation = new Animation(){

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            int targetEnd = 0;
            int targetTop = (int)((float)RecyclerRefreshLayout.this.mFrom + (float)(targetEnd - RecyclerRefreshLayout.this.mFrom) * interpolatedTime);
            RecyclerRefreshLayout.this.scrollTargetOffset(0, -RecyclerRefreshLayout.this.mCurrentScrollOffset - targetTop);
        }
    };
    private final Animation.AnimationListener mRefreshingListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            RecyclerRefreshLayout.this.mIRefreshStatus.refreshing();
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (RecyclerRefreshLayout.this.mNotify && RecyclerRefreshLayout.this.mOnRefreshListener != null) {
                RecyclerRefreshLayout.this.mOnRefreshListener.onRefresh();
            }
        }
    };
    private final Animation.AnimationListener mResetListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            RecyclerRefreshLayout.this.mIRefreshStatus.reset();
        }
    };

    public RecyclerRefreshLayout(Context context) {
        this(context, null);
    }

    public RecyclerRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mInterpolator = new DecelerateInterpolator(2.0f);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mSpinnerSize = (int)(30.0f * metrics.density);
        this.mRefreshTargetOffset = 50.0f * metrics.density;
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.setWillNotDraw(false);
        this.onCreateRefreshView();
        this.setNestedScrollingEnabled(true);
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
    }

    protected void onCreateRefreshView() {
        this.mRefreshView = new RefreshView(this.getContext());
        if (!(this.mRefreshView instanceof IRefreshStatus)) {
            throw new ClassCastException("the refreshView must implement the interface IRefreshStatus");
        }
        this.mIRefreshStatus = (IRefreshStatus)this.mRefreshView;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, this.mSpinnerSize);
        this.addView(this.mRefreshView, layoutParams);
    }

    public void setRefreshView(View refreshView, ViewGroup.LayoutParams layoutParams) {
        if (this.mRefreshView == refreshView) {
            return;
        }
        if (this.mRefreshView != null && this.mRefreshView.getParent() != null) {
            ((ViewGroup)this.mRefreshView.getParent()).removeView(this.mRefreshView);
        }
        this.mRefreshView = refreshView;
        if (!(this.mRefreshView instanceof IRefreshStatus)) {
            throw new ClassCastException("the refreshView must implement the interface IRefreshStatus");
        }
        this.mIRefreshStatus = (IRefreshStatus)this.mRefreshView;
        this.addView(this.mRefreshView, layoutParams);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setAnimateDuration(int duration) {
        this.mAnimateDuration = duration;
    }

    public void setRefreshTargetOffset(float refreshTargetOffset) {
        this.mRefreshTargetOffset = refreshTargetOffset;
        this.requestLayout();
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mRefreshViewIndex < 0) {
            return i;
        }
        if (i == childCount - 1) {
            return this.mRefreshViewIndex;
        }
        if (i >= this.mRefreshViewIndex) {
            return i + 1;
        }
        return i;
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        if (this.isEnabled() && (nestedScrollAxes & 2) != 0) {
            this.startNestedScroll(nestedScrollAxes & 2);
            return true;
        }
        return false;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.mTotalUnconsumed = 0.0f;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int[] parentConsumed;
        if (dy > 0 && this.mTotalUnconsumed > 0.0f) {
            if ((float)dy > this.mTotalUnconsumed) {
                consumed[1] = dy - (int)this.mTotalUnconsumed;
                this.mTotalUnconsumed = 0.0f;
            } else {
                this.mTotalUnconsumed -= (float)dy;
                consumed[1] = dy;
            }
            this.moveSpinner(this.mTotalUnconsumed);
        }
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed = this.mParentScrollConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        if (this.mTotalUnconsumed > 0.0f) {
            this.finishSpinner(this.mTotalUnconsumed);
            this.mTotalUnconsumed = 0.0f;
        }
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        if (dyUnconsumed < 0) {
            dyUnconsumed = Math.abs(dyUnconsumed);
            this.mTotalUnconsumed += (float)dyUnconsumed;
            this.moveSpinner(this.mTotalUnconsumed);
        }
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dxConsumed, null);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildCount() == 0) {
            return;
        }
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int childTop = this.getPaddingTop();
        int childLeft = this.getPaddingLeft();
        int childWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int childHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        this.mTarget.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        if (this.mRefreshTargetOffset < (float)this.mRefreshView.getHeight()) {
            this.mRefreshTargetOffset = this.mRefreshView.getHeight();
        }
        int offsetTop = (int)(-(this.mRefreshTargetOffset - (this.mRefreshTargetOffset - (float)this.mRefreshView.getMeasuredHeight()) / 2.0f));
        this.mRefreshView.layout(width / 2 - this.mRefreshView.getMeasuredWidth() / 2, offsetTop, width / 2 + this.mRefreshView.getMeasuredWidth() / 2, offsetTop + this.mRefreshView.getMeasuredHeight());
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        this.mTarget.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
        this.mRefreshView.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mRefreshView.getLayoutParams().height, (int)0x40000000));
        this.mRefreshViewIndex = -1;
        for (int index = 0; index < this.getChildCount(); ++index) {
            if (this.getChildAt(index) != this.mRefreshView) continue;
            this.mRefreshViewIndex = index;
            break;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        if (this.mTarget == null) {
            return false;
        }
        if (this.mRefreshing) {
            return true;
        }
        if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp(this.mTarget)) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.scrollTargetOffset(0, 0);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                float initialDownY = this.getMotionEventY(ev, this.mActivePointerId);
                if (initialDownY == -1.0f) {
                    return false;
                }
                this.mInitialDownY = initialDownY;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float activeMoveY = this.getMotionEventY(ev, this.mActivePointerId);
                if (activeMoveY == -1.0f) {
                    return false;
                }
                this.initDragStatus(activeMoveY);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                break;
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        if (this.mTarget == null) {
            return false;
        }
        if (this.mRefreshing) {
            return true;
        }
        if (this.mReturningToStart && ev.getAction() == 0) {
            this.mReturningToStart = false;
        }
        if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp(this.mTarget)) {
            return false;
        }
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float activeMoveY = this.getMotionEventY(ev, this.mActivePointerId);
                if (activeMoveY == -1.0f) {
                    return false;
                }
                float overScrollY = (activeMoveY - this.mInitialMotionY) * 0.5f;
                if (this.mIsBeingDragged) {
                    if (overScrollY > 0.0f) {
                        this.moveSpinner(overScrollY);
                        break;
                    }
                    return false;
                }
                this.initDragStatus(activeMoveY);
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float activeMoveY = this.getMotionEventY(ev, this.mActivePointerId);
                if (activeMoveY == -1.0f) {
                    this.mIsBeingDragged = false;
                    this.mActivePointerId = -1;
                    return false;
                }
                if (!this.mIsBeingDragged) {
                    return false;
                }
                float overScrollTop = (activeMoveY - this.mInitialMotionY) * 0.5f;
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                this.finishSpinner(overScrollTop);
                return false;
            }
        }
        return true;
    }

    public void setRefreshing(boolean refreshing) {
        if (refreshing && this.mRefreshing != refreshing) {
            this.mRefreshing = refreshing;
            this.scrollTargetOffset(0, 0);
            this.mNotify = false;
            this.animateToRefreshingPosition(-this.mCurrentScrollOffset, this.mRefreshingListener);
        } else {
            this.setRefreshing(refreshing, false);
        }
    }

    private void setRefreshing(boolean refreshing, boolean notify) {
        if (this.mRefreshing != refreshing) {
            this.mNotify = notify;
            this.mRefreshing = refreshing;
            if (refreshing) {
                this.animateToRefreshingPosition(-this.mCurrentScrollOffset, this.mRefreshingListener);
            } else {
                this.animateOffsetToStartPosition(-this.mCurrentScrollOffset, this.mResetListener);
            }
        }
    }

    private void initDragStatus(float activeMoveY) {
        float diff = activeMoveY - this.mInitialDownY;
        if (!this.mIsBeingDragged && diff > (float)this.mTouchSlop) {
            this.mInitialMotionY = this.mInitialDownY + diff;
            this.mIsBeingDragged = true;
        }
    }

    private void animateOffsetToStartPosition(int from, Animation.AnimationListener listener) {
        this.mFrom = from;
        this.mAnimateToStartAnimation.reset();
        this.mAnimateToStartAnimation.setDuration((long)this.mAnimateDuration);
        this.mAnimateToStartAnimation.setInterpolator(this.mInterpolator);
        if (listener != null) {
            this.mAnimateToStartAnimation.setAnimationListener(listener);
        }
        this.clearAnimation();
        this.startAnimation(this.mAnimateToStartAnimation);
    }

    private void animateToRefreshingPosition(int from, Animation.AnimationListener listener) {
        this.mFrom = from;
        this.mAnimateToRefreshingAnimation.reset();
        this.mAnimateToRefreshingAnimation.setDuration((long)this.mAnimateDuration);
        this.mAnimateToRefreshingAnimation.setInterpolator(this.mInterpolator);
        if (listener != null) {
            this.mAnimateToRefreshingAnimation.setAnimationListener(listener);
        }
        this.clearAnimation();
        this.startAnimation(this.mAnimateToRefreshingAnimation);
    }

    private void moveSpinner(float overScrollTop) {
        float originalDragPercent = overScrollTop / this.mRefreshTargetOffset;
        float dragPercent = Math.min(1.0f, Math.abs(originalDragPercent));
        float slingshotDist = this.mRefreshTargetOffset;
        float extraOS = Math.abs(overScrollTop) - this.mRefreshTargetOffset;
        float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, slingshotDist * 2.5f) / slingshotDist);
        float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
        float extraMove = slingshotDist * tensionPercent * 2.0f;
        int targetY = (int)(slingshotDist * dragPercent + extraMove);
        if (this.mRefreshView.getVisibility() != 0) {
            this.mRefreshView.setVisibility(0);
        }
        if (overScrollTop > this.mRefreshTargetOffset && !this.mIsFitRefreshing) {
            this.mIsFitRefreshing = true;
            this.mIRefreshStatus.pullToRefresh();
        } else if (overScrollTop <= this.mRefreshTargetOffset && this.mIsFitRefreshing) {
            this.mIsFitRefreshing = false;
            this.mIRefreshStatus.releaseToRefresh();
        }
        this.scrollTargetOffset(0, -this.mCurrentScrollOffset - targetY);
    }

    private void finishSpinner(float overScrollTop) {
        if (overScrollTop > this.mRefreshTargetOffset) {
            this.setRefreshing(true, true);
        } else {
            this.mRefreshing = false;
            this.animateOffsetToStartPosition(-this.mCurrentScrollOffset, this.mResetListener);
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private void scrollTargetOffset(int offsetX, int offsetY) {
        this.mRefreshView.bringToFront();
        this.scrollBy(offsetX, offsetY);
        this.mCurrentScrollOffset = this.getScrollY();
        this.mIRefreshStatus.pullProgress(-this.mCurrentScrollOffset, (float)(-this.mCurrentScrollOffset) / this.mRefreshTargetOffset);
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)ev, (int)index);
    }

    public boolean canChildScrollUp(View mTarget) {
        if (mTarget == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14 && mTarget instanceof AbsListView) {
            AbsListView absListView = (AbsListView)mTarget;
            return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
        }
        if (mTarget instanceof ViewGroup) {
            int childCount = ((ViewGroup)mTarget).getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = ((ViewGroup)mTarget).getChildAt(i);
                if (!this.canChildScrollUp(child)) continue;
                return true;
            }
        }
        return ViewCompat.canScrollVertically((View)mTarget, (int)-1) || mTarget.getScrollY() > 0;
    }

    private void ensureTarget() {
        if (!this.isTargetValid()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child.equals(this.mRefreshView)) continue;
                this.mTarget = child;
                break;
            }
        }
    }

    public boolean isTargetValid() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.mTarget != this.getChildAt(i)) continue;
            return true;
        }
        return false;
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

