/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.io.ByteStreams;
import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.GradleCompat;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.spotless.DirtyState;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.NoLambda;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;

final class IdeHook {
    static final String PROPERTY = "spotlessIdeHook";
    static final String USE_STD_IN = "spotlessIdeHookUseStdIn";
    static final String USE_STD_OUT = "spotlessIdeHookUseStdOut";

    private static void dumpIsClean() {
        System.err.println("IS CLEAN");
    }

    static void performHook(SpotlessTaskImpl spotlessTask, State state) {
        File file = new File(state.path);
        if (!file.isAbsolute()) {
            System.err.println("Argument passed to spotlessIdeHook must be an absolute path");
            return;
        }
        if (spotlessTask.getTarget().contains(file)) {
            GitRatchetGradle ratchet = spotlessTask.getRatchet();
            try (Formatter formatter = spotlessTask.buildFormatter();){
                if (ratchet != null && ratchet.isClean(((Directory)spotlessTask.getProjectDir().get()).getAsFile(), spotlessTask.getRootTreeSha(), file)) {
                    IdeHook.dumpIsClean();
                    return;
                }
                byte[] bytes = state.useStdIn ? ByteStreams.toByteArray((InputStream)System.in) : Files.readAllBytes(file.toPath());
                DirtyState dirty = DirtyState.of((Formatter)formatter, (File)file, (byte[])bytes);
                if (dirty.isClean()) {
                    IdeHook.dumpIsClean();
                } else if (dirty.didNotConverge()) {
                    System.err.println("DID NOT CONVERGE");
                    System.err.println("Run 'spotlessDiagnose' for details https://github.com/diffplug/spotless/blob/main/PADDEDCELL.md");
                } else {
                    System.err.println("IS DIRTY");
                    if (state.useStdOut) {
                        dirty.writeCanonicalTo((OutputStream)System.out);
                    } else {
                        dirty.writeCanonicalTo(file);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                throw Errors.asRuntime((Throwable)e);
            }
            finally {
                System.err.close();
                System.out.close();
            }
        }
    }

    private IdeHook() {
    }

    static class State
    extends NoLambda.EqualityBasedOnSerialization {
        @Nullable
        final String path;
        final boolean useStdIn;
        final boolean useStdOut;

        State(Project project) {
            this.path = GradleCompat.findOptionalProperty(project, IdeHook.PROPERTY);
            if (this.path != null) {
                this.useStdIn = GradleCompat.isPropertyPresent(project, IdeHook.USE_STD_IN);
                this.useStdOut = GradleCompat.isPropertyPresent(project, IdeHook.USE_STD_OUT);
            } else {
                this.useStdIn = false;
                this.useStdOut = false;
            }
        }
    }
}

