/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.spotless.extra.GitRatchet;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class GitRatchetGradle
extends GitRatchet<File> {
    private static final String[] GIT_EXEC_CANDIDATES = new String[]{"git", "git.exe", "git.cmd"};

    static void redirectJGitExecutions() {
        SystemReader existing = SystemReader.getInstance();
        SystemReader.setInstance((SystemReader)new DelegatingSystemReader(existing){
            private AtomicReference<FileBasedConfig> systemConfig = new AtomicReference();

            public StoredConfig getSystemConfig() throws ConfigInvalidException, IOException {
                FileBasedConfig c = this.systemConfig.get();
                if (c == null) {
                    this.systemConfig.compareAndSet(null, this.openSystemConfig((Config)this.getJGitConfig(), FS.DETECTED));
                    c = this.systemConfig.get();
                }
                this.updateAll((Config)c);
                return c;
            }

            private void updateAll(Config config) throws ConfigInvalidException, IOException {
                FileBasedConfig cfg;
                if (config == null) {
                    return;
                }
                this.updateAll(config.getBaseConfig());
                if (config instanceof FileBasedConfig && (cfg = (FileBasedConfig)config).isOutdated()) {
                    cfg.load();
                }
            }

            @Override
            public FileBasedConfig openSystemConfig(Config parent, FS fs) {
                File prefix;
                File systemConfig;
                String systemPath = this.getenv("GIT_CONFIG_SYSTEM");
                if (systemPath != null) {
                    fs.setGitSystemConfig(new File(systemPath).getAbsoluteFile());
                    return super.openSystemConfig(parent, fs);
                }
                File gitExec = null;
                String path = this.getenv("PATH");
                if (path != null) {
                    block0: for (String p : path.split(File.pathSeparator)) {
                        for (String name : GIT_EXEC_CANDIDATES) {
                            File candidate = new File(p, name);
                            if (!candidate.isFile() || !candidate.canExecute()) continue;
                            gitExec = candidate.getAbsoluteFile();
                            break block0;
                        }
                    }
                }
                if (gitExec != null && (systemConfig = new File(prefix = gitExec.getParentFile().getParentFile(), "etc/gitconfig")).exists()) {
                    fs.setGitSystemConfig(systemConfig);
                    return super.openSystemConfig(parent, fs);
                }
                fs.setGitSystemConfig(new File("/etc/gitconfig"));
                return super.openSystemConfig(parent, fs);
            }
        });
    }

    protected File getDir(File project) {
        return project;
    }

    @Nullable
    protected File getParent(File project) {
        return project.getParentFile();
    }

    static {
        GitRatchetGradle.redirectJGitExecutions();
    }

    static class DelegatingSystemReader
    extends SystemReader {
        final SystemReader reader;

        DelegatingSystemReader(SystemReader reader) {
            this.reader = reader;
        }

        public String getHostname() {
            return this.reader.getHostname();
        }

        public String getenv(String variable) {
            return this.reader.getenv(variable);
        }

        public String getProperty(String key) {
            return this.reader.getProperty(key);
        }

        public FileBasedConfig openUserConfig(Config parent, FS fs) {
            return this.reader.openUserConfig(parent, fs);
        }

        public FileBasedConfig openSystemConfig(Config parent, FS fs) {
            return this.reader.openSystemConfig(parent, fs);
        }

        public FileBasedConfig openJGitConfig(Config parent, FS fs) {
            return this.reader.openJGitConfig(parent, fs);
        }

        public long getCurrentTime() {
            return this.reader.getCurrentTime();
        }

        public int getTimezone(long when) {
            return this.reader.getTimezone(when);
        }
    }
}

