/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;

public class SpotlessPluginRedirect
implements Plugin<Project> {
    private static final Pattern BAD_SEMVER = Pattern.compile("(\\d+)\\.(\\d+)");

    static int badSemver(String input) {
        Matcher matcher = BAD_SEMVER.matcher(input);
        if (!matcher.find() || matcher.start() != 0) {
            throw new IllegalArgumentException("Version must start with " + BAD_SEMVER.pattern());
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        return SpotlessPluginRedirect.badSemver(Integer.parseInt(major), Integer.parseInt(minor));
    }

    static int badSemverOfGradle() {
        return SpotlessPluginRedirect.badSemver(GradleVersion.current().getVersion());
    }

    private static int badSemver(int major, int minor) {
        return major * 1000000 + minor;
    }

    static boolean gradleIsTooOld() {
        return SpotlessPluginRedirect.badSemverOfGradle() < SpotlessPluginRedirect.badSemver("7.3");
    }

    public void apply(Project project) {
        String errorMsg = StringPrinter.buildStringFromLines((String[])new String[]{"We have moved from 'com.diffplug.gradle.spotless'", "                to 'com.diffplug.spotless'", "To migrate:", "- Test your build with: id 'com.diffplug.gradle.spotless' version '4.5.1'", "- Fix any deprecation warnings (shouldn't be many / any)", "- Now you can use:      id 'com.diffplug.spotless' version '5.0.0'", "", "That's all you really need to know, but as always, there are more details in the changelog:", "https://github.com/diffplug/spotless/blob/main/plugin-gradle/CHANGES.md", "", "While you're at it, you might want to search for \"target '**/\".  We used", "to  recommend that in our README, but it's a lot slower than something", "more specific like \"target 'src/**\".  Also, if you haven't tried them yet,", "take a look at our IDE integration and 'ratchetFrom'.  We've found them", "to be useful, hope you do too.", "", "If you like the idea behind 'ratchetFrom', you should checkout spotless-changelog", "https://github.com/diffplug/spotless-changelog"});
        if (SpotlessPluginRedirect.gradleIsTooOld()) {
            errorMsg = errorMsg.replace("To migrate:\n", "To migrate:\n- Upgrade Gradle to 7.3 or newer (you're on " + GradleVersion.current().getVersion() + ")\n");
        }
        throw new GradleException(errorMsg);
    }
}

