/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.ConfigurationCacheHackList;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.LintSuppression;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.Incremental;

@DisableCachingByDefault(because="abstract definition")
public abstract class SpotlessTask
extends DefaultTask {
    protected String encoding = "UTF-8";
    protected Provider<LineEnding.Policy> lineEndingsPolicy = null;
    private transient ObjectId rootTreeSha;
    private transient ObjectId subtreeSha = ObjectId.zeroId();
    protected String ratchetFrom;
    protected List<LintSuppression> lintSuppressions = new ArrayList<LintSuppression>();
    protected FileCollection target;
    protected File cleanDirectory = new File((File)this.getProject().getLayout().getBuildDirectory().getAsFile().get(), "spotless-clean/" + this.getName());
    protected File lintsDirectory = new File((File)this.getProject().getLayout().getBuildDirectory().getAsFile().get(), "spotless-lints/" + this.getName());
    private final ConfigurationCacheHackList stepsInternalRoundtrip = ConfigurationCacheHackList.forRoundtrip();
    private final ConfigurationCacheHackList stepsInternalEquality = ConfigurationCacheHackList.forEquality();

    @Internal
    abstract Property<SpotlessTaskService> getTaskService();

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Objects.requireNonNull(encoding);
    }

    @Input
    public Provider<LineEnding.Policy> getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    public void setLineEndingsPolicy(Provider<LineEnding.Policy> lineEndingsPolicy) {
        this.lineEndingsPolicy = lineEndingsPolicy;
    }

    public void setupRatchet(String ratchetFrom) {
        this.ratchetFrom = ratchetFrom;
        if (!ratchetFrom.isEmpty()) {
            GitRatchetGradle ratchet = ((SpotlessTaskService)this.getTaskService().get()).getRatchet();
            File projectDir = ((Directory)this.getProjectDir().get()).getAsFile();
            this.rootTreeSha = ratchet.rootTreeShaOf(projectDir, ratchetFrom);
            this.subtreeSha = ratchet.subtreeShaOf(projectDir, this.rootTreeSha);
        } else {
            this.subtreeSha = ObjectId.zeroId();
        }
    }

    @Internal
    abstract DirectoryProperty getProjectDir();

    @Internal
    GitRatchetGradle getRatchet() {
        return ObjectId.zeroId().equals((AnyObjectId)this.getRatchetSha()) ? null : ((SpotlessTaskService)this.getTaskService().get()).getRatchet();
    }

    @Internal
    ObjectId getRootTreeSha() {
        return this.rootTreeSha;
    }

    @Input
    public ObjectId getRatchetSha() {
        if (this.subtreeSha == null) {
            this.setupRatchet(this.ratchetFrom);
        }
        return this.subtreeSha;
    }

    public void setLintSuppressions(List<LintSuppression> lintSuppressions) {
        this.lintSuppressions = Objects.requireNonNull(lintSuppressions);
    }

    @Input
    public List<LintSuppression> getLintSuppressions() {
        return this.lintSuppressions;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @InputFiles
    public FileCollection getTarget() {
        return this.target;
    }

    public void setTarget(Iterable<File> target) {
        this.target = target instanceof FileCollection ? (FileCollection)target : this.getProject().files(new Object[]{target});
    }

    @OutputDirectory
    public File getCleanDirectory() {
        return this.cleanDirectory;
    }

    @OutputDirectory
    public File getLintsDirectory() {
        return this.lintsDirectory;
    }

    @Internal
    public ConfigurationCacheHackList getStepsInternalRoundtrip() {
        return this.stepsInternalRoundtrip;
    }

    @Input
    public ConfigurationCacheHackList getStepsInternalEquality() {
        return this.stepsInternalEquality;
    }

    public void setSteps(List<FormatterStep> steps) {
        PluginGradlePreconditions.requireElementsNonNull(steps);
        this.stepsInternalRoundtrip.clear();
        this.stepsInternalEquality.clear();
        this.stepsInternalRoundtrip.addAll(steps);
        this.stepsInternalEquality.addAll(steps);
    }

    String formatName() {
        String name = this.getName();
        if (name.startsWith("spotless")) {
            return name.substring("spotless".length()).toLowerCase(Locale.ROOT);
        }
        return name;
    }

    Formatter buildFormatter() {
        return Formatter.builder().lineEndingsPolicy((LineEnding.Policy)this.getLineEndingsPolicy().get()).encoding(Charset.forName(this.encoding)).steps(this.stepsInternalRoundtrip.getSteps()).build();
    }
}

