/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.maven.plugins.annotations.Parameter;

public class LicenseHeader
implements FormatterStepFactory {
    @Parameter
    private String file;
    @Parameter
    private String content;
    @Parameter
    private String delimiter;

    @Override
    public final FormatterStep newFormatterStep(FormatterStepConfig config) {
        String delimiterString;
        String string = delimiterString = this.delimiter != null ? this.delimiter : config.getLicenseHeaderDelimiter();
        if (delimiterString == null) {
            throw new IllegalArgumentException("You need to specify 'delimiter'.");
        }
        if (this.file != null ^ this.content != null) {
            boolean updateYear;
            LicenseHeaderStep.YearMode yearMode = "true".equals(config.spotlessSetLicenseHeaderYearsFromGitHistory().orElse("")) ? LicenseHeaderStep.YearMode.SET_FROM_GIT : ((updateYear = config.getRatchetFrom().isPresent()) ? LicenseHeaderStep.YearMode.UPDATE_TO_TODAY : LicenseHeaderStep.YearMode.PRESERVE);
            return LicenseHeaderStep.headerDelimiter(() -> this.readFileOrContent(config), (String)delimiterString).withYearMode(yearMode).build().filterByFile(LicenseHeaderStep.unsupportedJvmFilesFilter());
        }
        throw new IllegalArgumentException("Must specify exactly one of 'file' or 'content'.");
    }

    private String readFileOrContent(FormatterStepConfig config) throws IOException {
        if (this.content != null) {
            return this.content;
        }
        byte[] raw = Files.readAllBytes(config.getFileLocator().locateFile(this.file).toPath());
        return new String(raw, config.getEncoding());
    }
}

