/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Lint;
import java.io.Serializable;
import java.util.Objects;

public class LintSuppression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ALL = "*";
    private String path = "*";
    private String step = "*";
    private String shortCode = "*";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = Objects.requireNonNull(path);
    }

    public String getStep() {
        return this.step;
    }

    public void setStep(String step) {
        this.step = Objects.requireNonNull(step);
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public void setShortCode(String shortCode) {
        this.shortCode = Objects.requireNonNull(shortCode);
    }

    public boolean suppresses(String relativePath, FormatterStep formatterStep, Lint lint) {
        return !(!this.path.equals(ALL) && !this.path.equals(relativePath) || !this.step.equals(ALL) && !formatterStep.getName().equals(this.step) || !this.shortCode.equals(ALL) && !lint.getShortCode().equals(this.shortCode));
    }

    public void ensureDoesNotSuppressAll() {
        boolean suppressAll;
        boolean bl = suppressAll = this.path.equals(ALL) && this.step.equals(ALL) && this.shortCode.equals(ALL);
        if (suppressAll) {
            throw new IllegalArgumentException("You must specify a specific `file`, `step`, or `shortCode`.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LintSuppression that = (LintSuppression)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.step, that.step) && Objects.equals(this.shortCode, that.shortCode);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.step, this.shortCode);
    }

    public String toString() {
        return "LintSuppression{file='" + this.path + "', step='" + this.step + "', code='" + this.shortCode + "'}";
    }
}

