/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonPatchStep {
    static final String MAVEN_COORDINATE = "com.flipkart.zjsonpatch:zjsonpatch";
    static final String DEFAULT_VERSION = "0.4.14";

    private JsonPatchStep() {
    }

    public static FormatterStep create(String patchString, Provisioner provisioner) {
        return JsonPatchStep.create(DEFAULT_VERSION, patchString, provisioner);
    }

    public static FormatterStep create(String zjsonPatchVersion, String patchString, Provisioner provisioner) {
        Objects.requireNonNull(zjsonPatchVersion, "zjsonPatchVersion cannot be null");
        Objects.requireNonNull(patchString, "patchString cannot be null");
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.createLazy("apply-json-patch", () -> new State(zjsonPatchVersion, patchString, provisioner), State::toFormatter);
    }

    public static FormatterStep create(List<Map<String, Object>> patch, Provisioner provisioner) {
        return JsonPatchStep.create(DEFAULT_VERSION, patch, provisioner);
    }

    public static FormatterStep create(String zjsonPatchVersion, List<Map<String, Object>> patch, Provisioner provisioner) {
        Objects.requireNonNull(zjsonPatchVersion, "zjsonPatchVersion cannot be null");
        Objects.requireNonNull(patch, "patch cannot be null");
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.createLazy("apply-json-patch", () -> new State(zjsonPatchVersion, patch, provisioner), State::toFormatter);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final List<Map<String, Object>> patch;
        private final String patchString;

        private State(String zjsonPatchVersion, List<Map<String, Object>> patch, Provisioner provisioner) throws IOException {
            this.jarState = JarState.from("com.flipkart.zjsonpatch:zjsonpatch:" + zjsonPatchVersion, provisioner);
            this.patch = patch;
            this.patchString = null;
        }

        private State(String zjsonPatchVersion, String patchString, Provisioner provisioner) throws IOException {
            this.jarState = JarState.from("com.flipkart.zjsonpatch:zjsonpatch:" + zjsonPatchVersion, provisioner);
            this.patch = null;
            this.patchString = patchString;
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.json.JsonPatchFormatterFunc");
            if (this.patch != null) {
                Constructor<?> constructor = formatterFunc.getConstructor(List.class);
                return (FormatterFunc)constructor.newInstance(this.patch);
            }
            Constructor<?> constructor = formatterFunc.getConstructor(String.class);
            return (FormatterFunc)constructor.newInstance(this.patchString);
        }
    }
}

