/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTFlattener;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ReturnTypeInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class TypeContextChecker {
    private static Type parseType(String typeString, IJavaScriptProject javaProject, List problemsCollector) {
        String typeNodeRange;
        if ("".equals(typeString.trim())) {
            return null;
        }
        if (!typeString.trim().equals(typeString)) {
            return null;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append("interface A{");
        int offset = cuBuff.length();
        cuBuff.append(typeString).append(" m();}");
        ASTParser p = ASTParser.newParser(3);
        p.setSource(cuBuff.toString().toCharArray());
        p.setProject(javaProject);
        JavaScriptUnit cu = (JavaScriptUnit)p.createAST(null);
        Selection selection = Selection.createFromStartLength(offset, typeString.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept(analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        if (!(selected instanceof Type)) {
            return null;
        }
        Type type = (Type)selected;
        if (MethodTypesSyntaxChecker.isVoidArrayType(type)) {
            return null;
        }
        IProblem[] problems = ASTNodes.getProblems(type, 0, 3);
        if (problems.length > 0) {
            int i = 0;
            while (i < problems.length) {
                problemsCollector.add(problems[i].getMessage());
                ++i;
            }
        }
        if (typeString.equals(typeNodeRange = cuBuff.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd(type)))) {
            return type;
        }
        return null;
    }

    private static ITypeBinding handleBug84585(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        return typeBinding;
    }

    public static RefactoringStatus[] checkAndResolveMethodTypes(IFunction method, StubTypeContext stubTypeContext, List parameterInfos, ReturnTypeInfo returnTypeInfo, IProblemVerifier problemVerifier) throws CoreException {
        MethodTypesChecker checker = new MethodTypesChecker(method, stubTypeContext, parameterInfos, returnTypeInfo, problemVerifier);
        return checker.checkAndResolveMethodTypes();
    }

    public static RefactoringStatus[] checkMethodTypesSyntax(IFunction method, List parameterInfos, ReturnTypeInfo returnTypeInfo) {
        MethodTypesSyntaxChecker checker = new MethodTypesSyntaxChecker(method, parameterInfos, returnTypeInfo);
        return checker.checkSyntax();
    }

    public static RefactoringStatus checkParameterTypeSyntax(String type, IJavaScriptProject project) {
        boolean valid;
        String newTypeName = ParameterInfo.stripEllipsis(type.trim()).trim();
        if ("".equals(newTypeName.trim())) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_parameter_type, new String[]{type});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        if (ParameterInfo.isVarargs(type) && !JavaModelUtil.is50OrHigher(project)) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_no_vararg_below_50, new String[]{type});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        ArrayList problemsCollector = new ArrayList(0);
        Type parsedType = TypeContextChecker.parseType(newTypeName, project, problemsCollector);
        boolean bl = valid = parsedType != null;
        if (valid && parsedType instanceof PrimitiveType) {
            boolean bl2 = valid = !PrimitiveType.VOID.equals(((PrimitiveType)parsedType).getPrimitiveTypeCode());
        }
        if (!valid) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_type_name, new String[]{newTypeName});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        if (problemsCollector.size() == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = problemsCollector.iterator();
        while (iter.hasNext()) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_type_syntax, new String[]{newTypeName, (String)iter.next()});
            result.addError(msg);
        }
        return result;
    }

    public static StubTypeContext createStubTypeContext(IJavaScriptUnit cu, JavaScriptUnit root, int focalPosition) throws CoreException {
        IDocument document = RefactoringFileBuffers.acquire(cu).getDocument();
        try {
            List<ASTNode> imports;
            StringBuffer bufBefore = new StringBuffer();
            StringBuffer bufAfter = new StringBuffer();
            int introEnd = 0;
            PackageDeclaration pack = root.getPackage();
            if (pack != null) {
                introEnd = pack.getStartPosition() + pack.getLength();
            }
            if ((imports = root.imports()).size() > 0) {
                ImportDeclaration lastImport = (ImportDeclaration)imports.get(imports.size() - 1);
                introEnd = lastImport.getStartPosition() + lastImport.getLength();
            }
            try {
                bufBefore.append(document.get(0, introEnd));
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, root.types());
            bufBefore.append(' ');
            bufAfter.insert(0, ' ');
            StubTypeContext stubTypeContext = new StubTypeContext(cu, bufBefore.toString(), bufAfter.toString());
            return stubTypeContext;
        }
        finally {
            RefactoringFileBuffers.release(cu);
        }
    }

    private static void fillWithTypeStubs(final StringBuffer bufBefore, final StringBuffer bufAfter, final int focalPosition, List types) {
        for (BodyDeclaration bodyDeclaration : types) {
            StringBuffer buf;
            if (!(bodyDeclaration instanceof AbstractTypeDeclaration)) {
                if (!(bodyDeclaration instanceof FunctionDeclaration)) continue;
                int bodyStart = bodyDeclaration.getStartPosition();
                int bodyEnd = bodyDeclaration.getStartPosition() + bodyDeclaration.getLength();
                if (bodyStart >= focalPosition || focalPosition >= bodyEnd) continue;
                FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclaration;
                buf = bufBefore;
                TypeContextChecker.appendModifiers(buf, methodDeclaration.modifiers());
                buf.append(" void ");
                buf.append(methodDeclaration.getName().getIdentifier());
                buf.append("(){\n");
                Block body = methodDeclaration.getBody();
                body.accept(new HierarchicalASTVisitor(){

                    @Override
                    public boolean visit(AbstractTypeDeclaration node) {
                        TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, Collections.singletonList(node));
                        return false;
                    }

                    @Override
                    public boolean visit(ClassInstanceCreation node) {
                        AnonymousClassDeclaration anonDecl = node.getAnonymousClassDeclaration();
                        if (anonDecl == null) {
                            return false;
                        }
                        int anonStart = anonDecl.getStartPosition();
                        int anonEnd = anonDecl.getStartPosition() + anonDecl.getLength();
                        if (anonStart >= focalPosition || focalPosition >= anonEnd) {
                            return false;
                        }
                        bufBefore.append(" new ");
                        bufBefore.append(node.getType().toString());
                        bufBefore.append("(){\n");
                        TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, anonDecl.bodyDeclarations());
                        bufAfter.insert(0, "};\n");
                        return false;
                    }
                });
                buf = bufAfter;
                buf.append("}\n");
                continue;
            }
            AbstractTypeDeclaration decl = (AbstractTypeDeclaration)bodyDeclaration;
            buf = decl.getStartPosition() < focalPosition ? bufBefore : bufAfter;
            TypeContextChecker.appendModifiers(buf, decl.modifiers());
            if (decl instanceof TypeDeclaration) {
                TypeDeclaration type = (TypeDeclaration)decl;
                buf.append("class ");
                buf.append(type.getName().getIdentifier());
                if (type.getSuperclassType() != null) {
                    buf.append(" extends ");
                    buf.append(ASTNodes.asString(type.getSuperclassType()));
                }
            }
            buf.append("{\n");
            TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, decl.bodyDeclarations());
            buf = decl.getStartPosition() + decl.getLength() < focalPosition ? bufBefore : bufAfter;
            buf.append("}\n");
        }
    }

    private static void appendModifiers(StringBuffer buf, List modifiers) {
        for (IExtendedModifier extendedModifier : modifiers) {
            if (!extendedModifier.isModifier()) continue;
            Modifier modifier = (Modifier)extendedModifier;
            buf.append(modifier.getKeyword().toString()).append(' ');
        }
    }

    public static StubTypeContext createSuperInterfaceStubTypeContext(String typeName, IType enclosingType, IPackageFragment packageFragment) {
        return TypeContextChecker.createSupertypeStubTypeContext(typeName, true, enclosingType, packageFragment);
    }

    public static StubTypeContext createSuperClassStubTypeContext(String typeName, IType enclosingType, IPackageFragment packageFragment) {
        return TypeContextChecker.createSupertypeStubTypeContext(typeName, false, enclosingType, packageFragment);
    }

    private static StubTypeContext createSupertypeStubTypeContext(String typeName, boolean isInterface, IType enclosingType, IPackageFragment packageFragment) {
        StubTypeContext stubTypeContext;
        String prolog = "class " + typeName + (isInterface ? " implements " : " extends ");
        String epilog = " {} ";
        if (enclosingType != null) {
            try {
                IJavaScriptUnit cu = enclosingType.getJavaScriptUnit();
                ISourceRange typeSourceRange = enclosingType.getSourceRange();
                int focalPosition = typeSourceRange.getOffset() + typeSourceRange.getLength() - 1;
                ASTParser parser = ASTParser.newParser(3);
                parser.setSource(cu);
                parser.setFocalPosition(focalPosition);
                JavaScriptUnit compilationUnit = (JavaScriptUnit)parser.createAST(null);
                stubTypeContext = TypeContextChecker.createStubTypeContext(cu, compilationUnit, focalPosition);
                stubTypeContext = new StubTypeContext(stubTypeContext.getCuHandle(), String.valueOf(stubTypeContext.getBeforeString()) + prolog, String.valueOf(epilog) + stubTypeContext.getAfterString());
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                stubTypeContext = new StubTypeContext(null, null, null);
            }
        } else if (packageFragment != null) {
            IJavaScriptUnit cu = packageFragment.getJavaScriptUnit("$$__$$.js");
            stubTypeContext = new StubTypeContext(cu, "package " + packageFragment.getElementName() + ";" + prolog, epilog);
        } else {
            stubTypeContext = new StubTypeContext(null, null, null);
        }
        return stubTypeContext;
    }

    public static Type parseSuperClass(String superClass) {
        return TypeContextChecker.parseSuperType(superClass, false);
    }

    public static Type parseSuperInterface(String superInterface) {
        return TypeContextChecker.parseSuperType(superInterface, true);
    }

    private static Type parseSuperType(String superType, boolean isInterface) {
        if (!superType.trim().equals(superType)) {
            return null;
        }
        StringBuffer cuBuff = new StringBuffer();
        if (isInterface) {
            cuBuff.append("class __X__ implements ");
        } else {
            cuBuff.append("class __X__ extends ");
        }
        int offset = cuBuff.length();
        cuBuff.append(superType).append(" {}");
        ASTParser p = ASTParser.newParser(3);
        p.setSource(cuBuff.toString().toCharArray());
        HashMap options = new HashMap();
        JavaModelUtil.set50CompilanceOptions(options);
        p.setCompilerOptions(options);
        JavaScriptUnit cu = (JavaScriptUnit)p.createAST(null);
        ASTNode selected = NodeFinder.perform(cu, offset, superType.length());
        if (selected instanceof Name) {
            selected = selected.getParent();
        }
        if (selected.getStartPosition() != offset || selected.getLength() != superType.length() || !(selected instanceof Type) || selected instanceof PrimitiveType) {
            return null;
        }
        Type type = (Type)selected;
        String typeNodeRange = cuBuff.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd(type));
        if (!superType.equals(typeNodeRange)) {
            return null;
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITypeBinding resolveSuperClass(String superclass, IType typeHandle, StubTypeContext superClassContext) {
        StringBuffer cuString = new StringBuffer();
        cuString.append(superClassContext.getBeforeString());
        cuString.append(superclass);
        cuString.append(superClassContext.getAfterString());
        try {
            IJavaScriptUnit wc = typeHandle.getJavaScriptUnit().getWorkingCopy(new WorkingCopyOwner(){}, (IProgressMonitor)new NullProgressMonitor());
            try {
                wc.getBuffer().setContents(cuString.toString());
                JavaScriptUnit compilationUnit = new RefactoringASTParser(3).parse(wc, true);
                ASTNode type = NodeFinder.perform(compilationUnit, superClassContext.getBeforeString().length(), superclass.length());
                if (type instanceof Type) {
                    ITypeBinding iTypeBinding = TypeContextChecker.handleBug84585(((Type)type).resolveBinding());
                    return iTypeBinding;
                }
                if (!(type instanceof Name)) throw new IllegalStateException();
                ASTNode parent = type.getParent();
                if (!(parent instanceof Type)) throw new IllegalStateException();
                ITypeBinding iTypeBinding = TypeContextChecker.handleBug84585(((Type)parent).resolveBinding());
                return iTypeBinding;
            }
            finally {
                wc.discardWorkingCopy();
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ITypeBinding[] resolveSuperInterfaces(String[] interfaces, IType typeHandle, StubTypeContext superInterfaceContext) {
        ITypeBinding[] result = new ITypeBinding[interfaces.length];
        int[] interfaceOffsets = new int[interfaces.length];
        StringBuffer cuString = new StringBuffer();
        cuString.append(superInterfaceContext.getBeforeString());
        int last = interfaces.length - 1;
        int i = 0;
        while (i <= last) {
            interfaceOffsets[i] = cuString.length();
            cuString.append(interfaces[i]);
            if (i != last) {
                cuString.append(", ");
            }
            ++i;
        }
        cuString.append(superInterfaceContext.getAfterString());
        try {
            IJavaScriptUnit wc = typeHandle.getJavaScriptUnit().getWorkingCopy(new WorkingCopyOwner(){}, (IProgressMonitor)new NullProgressMonitor());
            try {
                wc.getBuffer().setContents(cuString.toString());
                JavaScriptUnit compilationUnit = new RefactoringASTParser(3).parse(wc, true);
                int i2 = 0;
                while (i2 <= last) {
                    ASTNode type = NodeFinder.perform(compilationUnit, interfaceOffsets[i2], interfaces[i2].length());
                    if (type instanceof Type) {
                        result[i2] = TypeContextChecker.handleBug84585(((Type)type).resolveBinding());
                    } else {
                        if (!(type instanceof Name)) throw new IllegalStateException();
                        ASTNode parent = type.getParent();
                        if (!(parent instanceof Type)) throw new IllegalStateException();
                        result[i2] = TypeContextChecker.handleBug84585(((Type)parent).resolveBinding());
                    }
                    ++i2;
                }
                return result;
            }
            finally {
                wc.discardWorkingCopy();
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return result;
    }

    public static interface IProblemVerifier {
        public boolean isError(IProblem var1, ASTNode var2);
    }

    private static class MethodTypesChecker {
        private static final String METHOD_NAME = "__$$__";
        private final IFunction fMethod;
        private final StubTypeContext fStubTypeContext;
        private final List fParameterInfos;
        private final ReturnTypeInfo fReturnTypeInfo;
        private final IProblemVerifier fProblemVerifier;

        public MethodTypesChecker(IFunction method, StubTypeContext stubTypeContext, List parameterInfos, ReturnTypeInfo returnTypeInfo, IProblemVerifier problemVerifier) {
            this.fMethod = method;
            this.fStubTypeContext = stubTypeContext;
            this.fParameterInfos = parameterInfos;
            this.fReturnTypeInfo = returnTypeInfo;
            this.fProblemVerifier = problemVerifier;
        }

        public RefactoringStatus[] checkAndResolveMethodTypes() throws CoreException {
            return new RefactoringStatus[0];
        }

        private ITypeBinding[] resolveBindings(String[] types, RefactoringStatus[] results, boolean firstPass) throws CoreException {
            int parameterCount = types.length - 1;
            ITypeBinding[] typeBindings = new ITypeBinding[types.length];
            StringBuffer cuString = new StringBuffer();
            cuString.append(this.fStubTypeContext.getBeforeString());
            int offsetBeforeMethodName = this.appendMethodDeclaration(cuString, types, parameterCount);
            cuString.append(this.fStubTypeContext.getAfterString());
            IJavaScriptUnit wc = this.fMethod.getJavaScriptUnit().getWorkingCopy(new WorkingCopyOwner(){}, (IProgressMonitor)new NullProgressMonitor());
            try {
                wc.getBuffer().setContents(cuString.toString());
                JavaScriptUnit compilationUnit = new RefactoringASTParser(3).parse(wc, true);
                ASTNode method = NodeFinder.perform(compilationUnit, offsetBeforeMethodName, METHOD_NAME.length()).getParent();
                Type[] typeNodes = new Type[types.length];
                if (method instanceof FunctionDeclaration) {
                    FunctionDeclaration methodDeclaration = (FunctionDeclaration)method;
                    typeNodes[parameterCount] = methodDeclaration.getReturnType2();
                    List parameters = methodDeclaration.parameters();
                    int i = 0;
                    while (i < parameterCount) {
                        typeNodes[i] = ((SingleVariableDeclaration)parameters.get(i)).getType();
                        ++i;
                    }
                }
                int i = 0;
                while (i < types.length) {
                    Type type = typeNodes[i];
                    if (type == null) {
                        String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_couldNotResolveType, types[i]);
                        results[i] = RefactoringStatus.createErrorStatus((String)msg);
                    } else {
                        results[i] = new RefactoringStatus();
                        IProblem[] problems = ASTNodes.getProblems(type, 0, 3);
                        if (problems.length > 0) {
                            int p = 0;
                            while (p < problems.length) {
                                if (this.isError(problems[p], type)) {
                                    results[i].addError(problems[p].getMessage());
                                }
                                ++p;
                            }
                        }
                        typeBindings[i] = type.resolveBinding();
                        typeBindings[i] = TypeContextChecker.handleBug84585(typeBindings[i]);
                        if (firstPass && typeBindings[i] == null) {
                            types[i] = this.qualifyTypes(type, results[i]);
                        }
                    }
                    ++i;
                }
                ITypeBinding[] iTypeBindingArray = typeBindings;
                return iTypeBindingArray;
            }
            finally {
                wc.discardWorkingCopy();
            }
        }

        private boolean isError(IProblem problem, Type type) {
            if (this.fProblemVerifier != null) {
                return this.fProblemVerifier.isError(problem, type);
            }
            return true;
        }

        private int appendMethodDeclaration(StringBuffer cuString, String[] types, int parameterCount) throws JavaScriptModelException {
            if (Flags.isStatic(this.fMethod.getFlags())) {
                cuString.append("static ");
            }
            cuString.append(types[parameterCount]).append(' ');
            int offsetBeforeMethodName = cuString.length();
            cuString.append(METHOD_NAME).append('(');
            int i = 0;
            while (i < parameterCount) {
                if (i > 0) {
                    cuString.append(',');
                }
                cuString.append(types[i]).append(" p").append(i);
                ++i;
            }
            cuString.append(");");
            return offsetBeforeMethodName;
        }

        private String qualifyTypes(Type type, final RefactoringStatus result) throws CoreException {
            class NestedException
            extends RuntimeException {
                private static final long serialVersionUID = 1L;

                NestedException(CoreException e) {
                    super(e);
                }
            }
            ASTFlattener flattener = new ASTFlattener(){

                @Override
                public boolean visit(SimpleName node) {
                    this.appendResolved(node.getIdentifier());
                    return false;
                }

                @Override
                public boolean visit(QualifiedName node) {
                    this.appendResolved(node.getFullyQualifiedName());
                    return false;
                }

                @Override
                public boolean visit(QualifiedType node) {
                    this.appendResolved(ASTNodes.asString(node));
                    return false;
                }

                private void appendResolved(String typeName) {
                    String resolvedType;
                    try {
                        resolvedType = MethodTypesChecker.resolveType(typeName, result, fMethod.getDeclaringType(), null);
                    }
                    catch (CoreException e) {
                        throw new NestedException(e);
                    }
                    this.fBuffer.append(resolvedType);
                }
            };
            try {
                type.accept(flattener);
            }
            catch (NestedException e) {
                throw (CoreException)e.getCause();
            }
            return flattener.getResult();
        }

        private static String resolveType(String elementTypeName, RefactoringStatus status, IType declaringType, IProgressMonitor pm) throws CoreException {
            List typeRefsFound;
            String[][] fqns = declaringType.resolveType(elementTypeName);
            if (fqns != null) {
                if (fqns.length == 1) {
                    return JavaModelUtil.concatenateName(fqns[0][0], fqns[0][1]);
                }
                if (fqns.length > 1) {
                    Object[] keys = new String[]{elementTypeName, String.valueOf(fqns.length)};
                    String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_ambiguous, keys);
                    status.addError(msg);
                    return elementTypeName;
                }
            }
            if ((typeRefsFound = MethodTypesChecker.findTypeInfos(elementTypeName, declaringType, pm)).size() == 0) {
                Object[] keys = new String[]{elementTypeName};
                String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_not_unique, keys);
                status.addError(msg);
                return elementTypeName;
            }
            if (typeRefsFound.size() == 1) {
                TypeNameMatch typeInfo = (TypeNameMatch)typeRefsFound.get(0);
                return typeInfo.getFullyQualifiedName();
            }
            Assert.isTrue((typeRefsFound.size() > 1 ? 1 : 0) != 0);
            Object[] keys = new String[]{elementTypeName, String.valueOf(typeRefsFound.size())};
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_ambiguous, keys);
            status.addError(msg);
            return elementTypeName;
        }

        private static List findTypeInfos(String typeName, IType contextType, IProgressMonitor pm) throws JavaScriptModelException {
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{contextType.getJavaScriptProject()}, true);
            IPackageFragment currPackage = contextType.getPackageFragment();
            ArrayList collectedInfos = new ArrayList();
            TypeNameMatchCollector requestor = new TypeNameMatchCollector(collectedInfos);
            int matchMode = 8;
            new SearchEngine().searchAllTypeNames(null, matchMode, typeName.toCharArray(), matchMode, 0, scope, requestor, 3, pm);
            ArrayList<TypeNameMatch> result = new ArrayList<TypeNameMatch>();
            for (TypeNameMatch curr : collectedInfos) {
                IType type = curr.getType();
                if (type == null) continue;
                boolean visible = true;
                try {
                    visible = JavaModelUtil.isVisible(type, currPackage);
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                if (!visible) continue;
                result.add(curr);
            }
            return result;
        }
    }

    private static class MethodTypesSyntaxChecker {
        private final IFunction fMethod;
        private final List fParameterInfos;
        private final ReturnTypeInfo fReturnTypeInfo;

        public MethodTypesSyntaxChecker(IFunction method, List parameterInfos, ReturnTypeInfo returnTypeInfo) {
            this.fMethod = method;
            this.fParameterInfos = parameterInfos;
            this.fReturnTypeInfo = returnTypeInfo;
        }

        public RefactoringStatus[] checkSyntax() {
            return new RefactoringStatus[0];
        }

        private RefactoringStatus checkParameterTypeSyntax(ParameterInfo info) {
            if (!info.isAdded() && !info.isTypeNameChanged()) {
                return null;
            }
            return TypeContextChecker.checkParameterTypeSyntax(info.getNewTypeName(), this.fMethod.getJavaScriptProject());
        }

        private RefactoringStatus checkReturnTypeSyntax() {
            String newTypeName = this.fReturnTypeInfo.getNewTypeName();
            if ("".equals(newTypeName.trim())) {
                String msg = RefactoringCoreMessages.TypeContextChecker_return_type_not_empty;
                return RefactoringStatus.createFatalErrorStatus((String)msg);
            }
            ArrayList problemsCollector = new ArrayList(0);
            Type parsedType = TypeContextChecker.parseType(newTypeName, this.fMethod.getJavaScriptProject(), problemsCollector);
            if (parsedType == null) {
                String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_return_type, new String[]{newTypeName});
                return RefactoringStatus.createFatalErrorStatus((String)msg);
            }
            if (problemsCollector.size() == 0) {
                return null;
            }
            RefactoringStatus result = new RefactoringStatus();
            Iterator iter = problemsCollector.iterator();
            while (iter.hasNext()) {
                String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_return_type_syntax, new String[]{newTypeName, (String)iter.next()});
                result.addError(msg);
            }
            return result;
        }

        private static boolean isVoidArrayType(Type type) {
            if (!type.isArrayType()) {
                return false;
            }
            ArrayType arrayType = (ArrayType)type;
            if (!arrayType.getComponentType().isPrimitiveType()) {
                return false;
            }
            PrimitiveType primitiveType = (PrimitiveType)arrayType.getComponentType();
            return primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID;
        }
    }
}

