/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.util.ImportedCollector;
import org.eclipse.wst.html.core.internal.htmlcss.AbstractCSSModelAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.traversal.DocumentTraversal;

public abstract class AbstractStyleSheetAdapter
extends AbstractCSSModelAdapter
implements ICSSStyleListener,
IStyleSheetAdapter {
    private final Class StyleSheetAdapterClass = IStyleSheetAdapter.class;
    private Collection styleChangedNodes;

    protected AbstractStyleSheetAdapter() {
    }

    @Override
    protected ICSSModel createModel() {
        return this.createModel(true);
    }

    protected ICSSModel createModel(boolean notify) {
        IModelProvideAdapter adapter;
        ICSSModel newModel = super.createModel();
        if (notify && newModel != null && (adapter = (IModelProvideAdapter)((INodeNotifier)((Object)this.getElement())).getAdapterFor(IModelProvideAdapter.class)) != null) {
            adapter.modelProvided(newModel);
        }
        return newModel;
    }

    @Override
    public StyleSheet getSheet() {
        ICSSModel model = this.getModel();
        if (model == null) {
            return null;
        }
        return (StyleSheet)((Object)model.getDocument());
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == this.StyleSheetAdapterClass;
    }

    @Override
    public void released() {
        ICSSModel currentModel = this.getModel();
        IModelProvideAdapter adapter = (IModelProvideAdapter)((INodeNotifier)((Object)this.getElement())).getAdapterFor(IModelProvideAdapter.class);
        this.setElement(null);
        this.setModel(null);
        if (adapter != null) {
            adapter.modelReleased(currentModel);
        }
        if (currentModel != null) {
            currentModel.releaseFromRead();
        }
    }

    @Override
    public void removed() {
        ICSSModel currentModel = this.getModel();
        this.setModel(null);
        IModelProvideAdapter adapter = (IModelProvideAdapter)((INodeNotifier)((Object)this.getElement())).getAdapterFor(IModelProvideAdapter.class);
        if (adapter != null) {
            adapter.modelRemoved(currentModel);
        }
        if (currentModel != null) {
            currentModel.releaseFromRead();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void styleChanged(ICSSModel srcModel, ICSSSelector[] removed, ICSSSelector[] added, String media) {
        block10: {
            element = this.getElement();
            if (element == null) {
                return;
            }
            doc = element.getOwnerDocument();
            if (doc == null) {
                return;
            }
            if (!(doc instanceof INodeNotifier)) break block10;
            adapters = ((INodeNotifier)doc).getAdapters();
            if (adapters == null) {
                return;
            }
            it = adapters.iterator();
            if (it != null) ** GOTO lbl17
            return;
lbl-1000:
            // 1 sources

            {
                adapter = (INodeAdapter)it.next();
                if (!(adapter instanceof ICSSStyleListener)) continue;
                ((ICSSStyleListener)adapter).styleChanged(srcModel, removed, added, media);
lbl17:
                // 3 sources

                ** while (it.hasNext())
            }
        }
        if (this.styleChangedNodes == null) {
            this.styleChangedNodes = new HashSet<E>();
        }
        try {
            removedSelNum = removed != null ? removed.length : 0;
            addedSelNum = added != null ? added.length : 0;
            iter = ((DocumentTraversal)doc).createNodeIterator(doc, 1, null, true);
            while ((node = iter.nextNode()) != null) {
                if (node.getNodeType() != 1) continue;
                elm = (Element)node;
                match = false;
                i = 0;
                while (i < removedSelNum && !match) {
                    match = removed[i].match(elm, null);
                    ++i;
                }
                i = 0;
                while (i < addedSelNum && !match) {
                    match = added[i].match(elm, null);
                    ++i;
                }
                if (!match || this.styleChangedNodes.contains(elm)) continue;
                this.styleChangedNodes.add(elm);
            }
        }
        catch (ClassCastException v0) {}
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void styleUpdate(ICSSModel srcModel) {
        block10: {
            node = (IDOMNode)this.getElement();
            if (node == null) {
                return;
            }
            model = node.getModel();
            if (model == null) {
                return;
            }
            notifier = model.getModelNotifier();
            if (notifier == null) {
                return;
            }
            document = (DocumentStyle)model.getDocument();
            styles = document.getStyleSheets();
            if (styles != null) {
                n = styles.getLength();
                trav = new ImportedCollector();
                i = 0;
                while (i < n) {
                    sheet = styles.item(i);
                    if (sheet instanceof ICSSNode) {
                        trav.apply((ICSSNode)sheet);
                    }
                    ++i;
                }
            }
            if (this.styleChangedNodes != null) {
                elements = this.styleChangedNodes.toArray();
                i = 0;
                while (elements != null && i < elements.length) {
                    this.notifyStyleChanged((Element)elements[i]);
                    ++i;
                }
                this.styleChangedNodes.clear();
            }
            if (!(document instanceof INodeNotifier)) break block10;
            adapters = ((INodeNotifier)document).getAdapters();
            if (adapters == null) {
                return;
            }
            it = adapters.iterator();
            if (it != null) ** GOTO lbl40
            return;
lbl-1000:
            // 1 sources

            {
                adapter = (INodeAdapter)it.next();
                if (!(adapter instanceof ICSSStyleListener)) continue;
                ((ICSSStyleListener)adapter).styleUpdate(srcModel);
lbl40:
                // 3 sources

                ** while (it.hasNext())
            }
        }
        notifier.propertyChanged(node);
    }
}

