/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DeclContainerFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPageRule;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class PageRuleFormatter
extends DeclContainerFormatter {
    public static final String PAGE = "@page";
    private static PageRuleFormatter instance;

    PageRuleFormatter() {
    }

    @Override
    public StringBuffer formatAttrChanged(ICSSNode node, ICSSAttr attr, boolean insert, AttrChangeContext context) {
        String val;
        StringBuffer buf = new StringBuffer();
        if (node == null || attr == null) {
            return buf;
        }
        if (!"selector".equalsIgnoreCase(attr.getName())) {
            return buf;
        }
        if (context != null && ((IndexedRegion)((Object)node)).getEndOffset() > 0) {
            if (attr != null && ((IndexedRegion)((Object)attr)).getEndOffset() > 0) {
                ITextRegion next;
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)((Object)attr)).getEndOffset() - 1);
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)((Object)attr)).getEndOffset() - 1);
                RegionIterator it = new RegionIterator(flatNode, region);
                it.next();
                context.end = it.hasNext() ? ((next = it.next()).getType() == "S" ? it.getStructuredDocumentRegion().getEndOffset(next) : it.getStructuredDocumentRegion().getEndOffset(region)) : it.getStructuredDocumentRegion().getEndOffset(region);
                context.start = it.getStructuredDocumentRegion().getStartOffset(region);
            } else {
                int pos;
                context.start = pos = this.getAttrInsertPos(node, attr.getName());
                context.end = pos;
            }
        }
        if (insert && (val = attr.getValue()) != null && val.length() > 0) {
            buf.append(val);
            this.appendSpaceBefore(node, "", buf);
        }
        return buf;
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        int end;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int start = ((IndexedRegion)((Object)node)).getStartOffset();
        int n = end = node.getFirstChild() != null && ((IndexedRegion)((Object)node.getFirstChild())).getEndOffset() > 0 ? ((IndexedRegion)((Object)node.getFirstChild())).getStartOffset() : this.getChildInsertPos(node);
        if (end > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBetween(node, regions[i - 1], regions[i], source);
                }
                source.append(this.decoratedIdentRegion(regions[i], stgy));
                ++i;
            }
        } else {
            String str = PAGE;
            if (CSSCorePlugin.getDefault().getPluginPreferences().getInt("identifierCase") == 2) {
                str = PAGE.toUpperCase();
            }
            source.append(str);
            str = ((ICSSPageRule)node).getSelectorText();
            if (str != null && str.length() > 0) {
                this.appendSpaceBefore(node, str, source);
                source.append(str);
            }
            this.appendSpaceBefore(node, "{", source);
            source.append("{");
        }
        this.appendDelimBefore(node, null, source);
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || PageRuleFormatter.needS(outside[0])) {
                this.appendSpaceBetween(node, i == 0 ? outside[0] : regions[i - 1], regions[i], source);
            }
            source.append(this.decoratedIdentRegion(regions[i], stgy));
            ++i;
        }
        if (PageRuleFormatter.needS(outside[1])) {
            if (this.isIncludesPreEnd(node, region)) {
                this.appendDelimBefore(node, null, source);
            } else {
                this.appendSpaceBetween(node, regions[regions.length - 1], outside[1], source);
            }
        }
    }

    @Override
    public int getAttrInsertPos(ICSSNode node, String attrName) {
        if (node == null || attrName == null || attrName.length() == 0) {
            return -1;
        }
        if (!"selector".equalsIgnoreCase(attrName)) {
            return -1;
        }
        ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem("selector");
        if (attr != null && ((IndexedRegion)((Object)attr)).getEndOffset() > 0) {
            return ((IndexedRegion)((Object)attr)).getStartOffset();
        }
        if (((IndexedRegion)((Object)node)).getEndOffset() > 0) {
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)((Object)node)).getStartOffset());
            ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)((Object)node)).getStartOffset());
            RegionIterator it = new RegionIterator(flatNode, region);
            while (it.hasNext()) {
                region = it.next();
                if (region.getType() == "LBRACE") {
                    return it.getStructuredDocumentRegion().getStartOffset(region);
                }
                if (it.getStructuredDocumentRegion().getEndOffset(region) >= ((IndexedRegion)((Object)node)).getEndOffset()) break;
            }
        }
        return ((IndexedRegion)((Object)node)).getStartOffset();
    }

    public static synchronized PageRuleFormatter getInstance() {
        if (instance == null) {
            instance = new PageRuleFormatter();
        }
        return instance;
    }
}

