/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import com.diffplug.spotless.extra.eclipse.wtp.sse.PluginPreferences;
import com.diffplug.spotless.extra.eclipse.wtp.sse.PreventExternalURIResolverExtension;
import java.util.Properties;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.dtd.core.internal.DTDCorePlugin;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.formatter.DefaultXMLPartitionFormatter;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormattingPreferences;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryAdapterFactoryForXML;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;
import org.eclipse.wst.xml.core.internal.preferences.XMLCorePreferenceInitializer;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xsd.core.internal.XSDCorePlugin;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;
import org.osgi.framework.BundleActivator;

public class EclipseXmlFormatterStepImpl {
    private final DefaultXMLPartitionFormatter formatter;
    private final XMLFormattingPreferences preferences;
    private final INodeAdapterFactory xmlAdapterFactory;

    public EclipseXmlFormatterStepImpl(Properties properties) throws Exception {
        SpotlessEclipseFramework.setup((SpotlessEclipseConfig)new FrameworkConfig(properties));
        PluginPreferences.assertNoChanges(XMLCorePlugin.getDefault(), properties);
        this.preferences = new XMLFormattingPreferences();
        this.formatter = new DefaultXMLPartitionFormatter();
        this.xmlAdapterFactory = new ModelQueryAdapterFactoryForXML();
    }

    public String format(String raw, String baseLocation) throws Exception {
        BasicStructuredDocument document = new BasicStructuredDocument(new XMLSourceParser());
        document.setPreferredLineDelimiter("\n");
        StructuredTextPartitionerForXML partitioner = new StructuredTextPartitionerForXML();
        document.setDocumentPartitioner(new StructuredTextPartitionerForXML());
        partitioner.connect(document);
        document.set(raw);
        DOMModelImpl xmlDOM = new DOMModelImpl();
        xmlDOM.setBaseLocation(baseLocation);
        xmlDOM.getFactoryRegistry().addFactory(this.xmlAdapterFactory);
        xmlDOM.setStructuredDocument(document);
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(xmlDOM);
        modelQuery.getCMDocumentManager().setPropertyEnabled("useCachedResovledURI", true);
        TextEdit formatterChanges = this.formatter.format(xmlDOM, 0, document.getLength(), this.preferences);
        formatterChanges.apply((IDocument)document);
        return document.get();
    }

    static class FrameworkConfig
    implements SpotlessEclipseConfig {
        private final Properties properties;

        FrameworkConfig(Properties properties) {
            properties.setProperty("cmDocumentGlobalCacheEnabled", Boolean.toString(false));
            this.properties = properties;
        }

        public void registerServices(SpotlessEclipseServiceConfig config) {
            config.applyDefault();
            config.useSlf4J(EclipseXmlFormatterStepImpl.class.getPackage().getName());
        }

        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            config.applyDefault();
            FrameworkConfig.activateXmlPlugins(config, PluginPreferences.isExternalUriAllowed(this.properties));
        }

        static void activateXmlPlugins(SpotlessEclipsePluginConfig config, boolean allowExternalURI) {
            config.add((BundleActivator)new XMLCorePlugin());
            config.add((BundleActivator)new URIResolverPlugin());
            config.add((BundleActivator)new DTDCorePlugin());
            config.add((BundleActivator)new XSDCorePlugin());
            if (!allowExternalURI) {
                config.add((BundleActivator)new PreventExternalURIResolverExtension());
            }
        }

        public void customize() {
            XSDSchemaBuildingTools.getXSDFactory();
            PluginPreferences.configure(XMLCorePlugin.getDefault(), new XMLCorePreferenceInitializer(), this.properties);
            PluginPreferences.configureCatalog(this.properties, (Catalog)XMLCorePlugin.getDefault().getDefaultXMLCatalog());
        }
    }
}

