/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public class ContentBasedPreferenceGateway {
    private static String DEFAULT_LOCATION = "org.eclipse.wst.sse.core";
    private static String RUNTIME_XML_ID = "org.eclipse.core.runtime.xml";
    private static String SSE_XML_ID = "org.eclipse.wst.xml.core.xmlsource";

    private static boolean bundleExists(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return bundle != null;
    }

    private static String getContributorPluginId(IContentType contentType) {
        String fullId = null;
        fullId = contentType == null ? DEFAULT_LOCATION : contentType.getId();
        if (RUNTIME_XML_ID.equals(fullId)) {
            fullId = SSE_XML_ID;
        }
        String pluginId = ContentBasedPreferenceGateway.inferPluginId(fullId);
        return pluginId;
    }

    private static Preferences getDefaultPreferences(IContentType contentType) {
        IEclipsePreferences eclipsePreferences = Platform.getPreferencesService().getRootNode();
        String pluginPreferenceLocation = "default/" + ContentBasedPreferenceGateway.getContributorPluginId(contentType);
        Preferences pluginPreferences = eclipsePreferences.node(pluginPreferenceLocation);
        return pluginPreferences;
    }

    private static Preferences getDefaultPreferences(String contentTypeId) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        return ContentBasedPreferenceGateway.getDefaultPreferences(contentType);
    }

    public static Preferences getPreferences(IContentType contentType) {
        IEclipsePreferences eclipsePreferences = Platform.getPreferencesService().getRootNode();
        String pluginPreferenceLocation = "instance/" + ContentBasedPreferenceGateway.getContributorPluginId(contentType);
        Preferences pluginPreferences = eclipsePreferences.node(pluginPreferenceLocation);
        return pluginPreferences;
    }

    public static Preferences getPreferences(String contentTypeId) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        return ContentBasedPreferenceGateway.getPreferences(contentType);
    }

    public static String getPreferencesString(IContentType contentType, String key) {
        Preferences preferences = ContentBasedPreferenceGateway.getPreferences(contentType);
        String value = preferences.get(key, ContentBasedPreferenceGateway.getDefaultPreferences(contentType).get(key, null));
        return value;
    }

    public static String getPreferencesString(String contentTypeId, String key) {
        Preferences preferences = ContentBasedPreferenceGateway.getPreferences(contentTypeId);
        String value = preferences.get(key, ContentBasedPreferenceGateway.getDefaultPreferences(contentTypeId).get(key, null));
        return value;
    }

    private static String inferPluginId(String fullId) {
        int lastSegmentPos = fullId.lastIndexOf(46);
        String pluginId = null;
        pluginId = lastSegmentPos != -1 ? fullId.substring(0, lastSegmentPos) : DEFAULT_LOCATION;
        if (!ContentBasedPreferenceGateway.bundleExists(pluginId)) {
            pluginId = DEFAULT_LOCATION;
        }
        return pluginId;
    }
}

