/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.json.core.internal.parser.JSONStructuredDocumentRegionFactory;
import org.eclipse.wst.json.core.internal.parser.JSONTokenizer;
import org.eclipse.wst.json.core.util.JSONUtil;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class JSONSourceParser
implements RegionParser {
    private long fStartTime;
    private long fStopTime;
    private JSONTokenizer fTokenizer;

    @Override
    public IStructuredDocumentRegion getDocumentRegions() {
        IStructuredDocumentRegion headnode = null;
        if (headnode == null) {
            headnode = this.parseNodes();
        }
        return headnode;
    }

    private IStructuredDocumentRegion parseNodes() {
        IStructuredDocumentRegion headNode = null;
        IStructuredDocumentRegion lastNode = null;
        ITextRegion region = null;
        IStructuredDocumentRegion currentNode = null;
        String type = null;
        String currentRegionType = null;
        try {
            while ((region = this.getNextRegion()) != null) {
                type = region.getType();
                if (this.mustBeStart(type, currentRegionType) && currentNode != null) {
                    currentNode.setEnded(true);
                }
                if (currentNode != null && currentNode.isEnded() || currentNode == null) {
                    if (currentNode != null && !currentNode.isEnded()) {
                        currentNode.setEnded(true);
                    }
                    lastNode = currentNode;
                    currentNode = this.createStructuredDocumentRegion(type);
                    currentRegionType = type;
                    if (lastNode != null) {
                        lastNode.setNext(currentNode);
                    }
                    currentNode.setPrevious(lastNode);
                    currentNode.setStart(region.getStart());
                }
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
                if (this.mustBeEnd(type)) {
                    currentNode.setEnded(true);
                }
                if (headNode != null || currentNode == null) continue;
                headNode = currentNode;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (currentNode != null && !currentNode.isEnded()) {
            currentNode.setEnded(true);
        }
        this.primReset();
        return headNode;
    }

    @Override
    public List getRegions() {
        IStructuredDocumentRegion headNode = null;
        if (!this.getTokenizer().isEOF()) {
            headNode = this.getDocumentRegions();
        }
        List localRegionsList = this.getRegions(headNode);
        this.primReset();
        return localRegionsList;
    }

    protected List getRegions(IStructuredDocumentRegion headNode) {
        ArrayList<ITextRegion> allRegions = new ArrayList<ITextRegion>();
        IStructuredDocumentRegion currentNode = headNode;
        while (currentNode != null) {
            ITextRegionList nodeRegions = currentNode.getRegions();
            int i = 0;
            while (i < nodeRegions.size()) {
                allRegions.add(nodeRegions.get(i));
                ++i;
            }
            currentNode = currentNode.getNext();
        }
        return allRegions;
    }

    @Override
    public RegionParser newInstance() {
        return new JSONSourceParser();
    }

    @Override
    public void reset(Reader reader) {
        this.primReset();
        this.getTokenizer().reset(reader, 0);
    }

    @Override
    public void reset(Reader reader, int offset) {
        this.reset(reader);
    }

    @Override
    public void reset(String input) {
        this.reset(new StringReader(input));
    }

    @Override
    public void reset(String input, int offset) {
        this.reset(input);
    }

    private IStructuredDocumentRegion createStructuredDocumentRegion(String type) {
        return JSONStructuredDocumentRegionFactory.createRegion(type);
    }

    protected boolean mustBeStart(String type, String docRegionType) {
        return JSONUtil.isStartJSONStructure(type) || JSONUtil.isEndJSONStructure(type) || JSONUtil.isJSONSimpleValue(type) || type == "JSON_OBJECT_KEY" || type == "JSON_COMMA" || type != "WHITE_SPACE" && docRegionType == "JSON_ARRAY_OPEN" || type != "WHITE_SPACE" && docRegionType == "JSON_COMMA";
    }

    protected boolean mustBeEnd(String regionType) {
        return JSONUtil.isEndJSONStructure(regionType);
    }

    private ITextRegion getNextRegion() {
        ITextRegion region = null;
        try {
            region = this.getTokenizer().getNextToken();
            return region;
        }
        catch (StackOverflowError e) {
            Logger.logException(String.valueOf(this.getClass().getName()) + ": input could not be parsed correctly at position " + this.getTokenizer().getOffset(), e);
            throw e;
        }
        catch (Exception e) {
            Logger.logException(String.valueOf(this.getClass().getName()) + ": input could not be parsed correctly at position " + this.getTokenizer().getOffset() + " (" + e.getLocalizedMessage() + ")", e);
            return null;
        }
    }

    private void primReset() {
        this.getTokenizer().reset(new char[0]);
    }

    private JSONTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new JSONTokenizer();
        }
        return this.fTokenizer;
    }

    private int _countNodes(IStructuredDocumentRegion nodes) {
        int result = 0;
        IStructuredDocumentRegion countNode = nodes;
        while (countNode != null) {
            ++result;
            countNode = countNode.getNext();
        }
        return result;
    }
}

