/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.MoveInstanceMethodAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.MoveStaticMembersAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMoveAction;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class MoveAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private MoveInstanceMethodAction fMoveInstanceMethodAction;
    private MoveStaticMembersAction fMoveStaticMembersAction;
    private ReorgMoveAction fReorgMoveAction;

    public MoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.MoveAction_text);
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(site);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(site);
        this.fReorgMoveAction = new ReorgMoveAction(site);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.move_action");
    }

    public MoveAction(JavaEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(RefactoringMessages.MoveAction_text);
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(editor);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(editor);
        this.fReorgMoveAction = new ReorgMoveAction((IWorkbenchSite)editor.getEditorSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.move_action");
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        this.fMoveStaticMembersAction.selectionChanged(event);
        this.fMoveInstanceMethodAction.selectionChanged(event);
        this.fReorgMoveAction.selectionChanged(event);
        this.setEnabled(this.computeEnableState());
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            if (this.fMoveInstanceMethodAction.isEnabled() && this.tryMoveInstanceMethod(selection)) {
                return;
            }
            if (this.fMoveStaticMembersAction.isEnabled() && this.tryMoveStaticMembers(selection)) {
                return;
            }
            if (this.fReorgMoveAction.isEnabled()) {
                this.fReorgMoveAction.run();
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            if (this.fMoveStaticMembersAction.isEnabled() && this.tryMoveStaticMembers(selection)) {
                return;
            }
            if (this.fMoveInstanceMethodAction.isEnabled() && this.tryMoveInstanceMethod(selection)) {
                return;
            }
            if (this.tryReorgMove(selection)) {
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.MoveAction_Move, (String)RefactoringMessages.MoveAction_select);
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private boolean tryMoveStaticMembers(ITextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null || !(element instanceof IMember)) {
            return false;
        }
        IMember[] array = new IMember[]{(IMember)element};
        if (!RefactoringAvailabilityTester.isMoveStaticMembersAvailable(array)) {
            return false;
        }
        this.fMoveStaticMembersAction.run(selection);
        return true;
    }

    private static IMember[] getSelectedMembers(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IMember) continue;
            return null;
        }
        return MoveAction.convertToMemberArray(selection.toArray());
    }

    private static IMember[] convertToMemberArray(Object[] obj) {
        if (obj == null) {
            return null;
        }
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(obj));
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    private boolean tryMoveStaticMembers(IStructuredSelection selection) throws JavaScriptModelException {
        IMember[] array = MoveAction.getSelectedMembers(selection);
        if (!RefactoringAvailabilityTester.isMoveStaticMembersAvailable(array)) {
            return false;
        }
        this.fMoveStaticMembersAction.run(selection);
        return true;
    }

    private boolean tryMoveInstanceMethod(ITextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null || !(element instanceof IFunction)) {
            return false;
        }
        IFunction method = (IFunction)element;
        if (!RefactoringAvailabilityTester.isMoveMethodAvailable(method)) {
            return false;
        }
        this.fMoveInstanceMethodAction.run(selection);
        return true;
    }

    private boolean tryMoveInstanceMethod(IStructuredSelection selection) throws JavaScriptModelException {
        IFunction method = MoveAction.getSingleSelectedMethod(selection);
        if (method == null) {
            return false;
        }
        if (!RefactoringAvailabilityTester.isMoveMethodAvailable(method)) {
            return false;
        }
        this.fMoveInstanceMethodAction.run(selection);
        return true;
    }

    private static IFunction getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IFunction)) {
            return null;
        }
        return (IFunction)first;
    }

    private boolean tryReorgMove(ITextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null) {
            return false;
        }
        StructuredSelection mockStructuredSelection = new StructuredSelection((Object)element);
        this.fReorgMoveAction.selectionChanged((IStructuredSelection)mockStructuredSelection);
        if (!this.fReorgMoveAction.isEnabled()) {
            return false;
        }
        this.fReorgMoveAction.run((IStructuredSelection)mockStructuredSelection);
        return true;
    }

    @Override
    public void update(ISelection selection) {
        this.fMoveStaticMembersAction.update(selection);
        this.fMoveInstanceMethodAction.update(selection);
        this.fReorgMoveAction.update(selection);
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        return this.fMoveStaticMembersAction.isEnabled() || this.fMoveInstanceMethodAction.isEnabled() || this.fReorgMoveAction.isEnabled();
    }
}

