/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class AccessRuleEntryDialog
extends StatusDialog {
    private StringDialogField fPatternDialog;
    private StatusInfo fPatternStatus;
    private String fPattern;
    private ComboDialogField fRuleKindCombo;
    private int[] fRuleKinds;

    public AccessRuleEntryDialog(Shell parent, IAccessRule ruleToEdit, CPListElement entryToEdit) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        String title = ruleToEdit == null ? NewWizardMessages.TypeRestrictionEntryDialog_add_title : NewWizardMessages.TypeRestrictionEntryDialog_edit_title;
        String message = Messages.format(NewWizardMessages.TypeRestrictionEntryDialog_pattern_label, entryToEdit.getPath().makeRelative().toString());
        this.setTitle(title);
        this.fPatternStatus = new StatusInfo();
        TypeRulesAdapter adapter = new TypeRulesAdapter();
        this.fPatternDialog = new StringDialogField();
        this.fPatternDialog.setLabelText(message);
        this.fPatternDialog.setDialogFieldListener(adapter);
        this.fRuleKindCombo = new ComboDialogField(8);
        this.fRuleKindCombo.setLabelText(NewWizardMessages.TypeRestrictionEntryDialog_kind_label);
        this.fRuleKindCombo.setDialogFieldListener(adapter);
        String[] items = new String[]{NewWizardMessages.TypeRestrictionEntryDialog_kind_non_accessible, NewWizardMessages.TypeRestrictionEntryDialog_kind_discourraged, NewWizardMessages.TypeRestrictionEntryDialog_kind_accessible};
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        this.fRuleKinds = nArray;
        this.fRuleKindCombo.setItems(items);
        if (ruleToEdit == null) {
            this.fPatternDialog.setText("");
            this.fRuleKindCombo.selectItem(0);
        } else {
            this.fPatternDialog.setText(ruleToEdit.getPattern().toString());
            int i = 0;
            while (i < this.fRuleKinds.length) {
                if (this.fRuleKinds[i] == ruleToEdit.getKind()) {
                    this.fRuleKindCombo.selectItem(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(4, 2, true, false));
        Label description = new Label(inner, 64);
        description.setText(NewWizardMessages.TypeRestrictionEntryDialog_description);
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        description.setLayoutData((Object)gd);
        this.fRuleKindCombo.doFillIntoGrid(inner, 2);
        this.fPatternDialog.doFillIntoGrid(inner, 2);
        Label description2 = new Label(inner, 64);
        description2.setText(NewWizardMessages.TypeRestrictionEntryDialog_description2);
        gd = new GridData(4, 2, true, false, 2, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        description2.setLayoutData((Object)gd);
        this.fPatternDialog.postSetFocusOnDialogField(parent.getDisplay());
        AccessRuleEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPatternValid();
        this.updateStatus(this.fPatternStatus);
    }

    protected void checkIfPatternValid() {
        String pattern = this.fPatternDialog.getText().trim();
        if (pattern.length() == 0) {
            this.fPatternStatus.setError(NewWizardMessages.TypeRestrictionEntryDialog_error_empty);
            return;
        }
        Path path = new Path(pattern);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.fPatternStatus.setError(NewWizardMessages.TypeRestrictionEntryDialog_error_notrelative);
            return;
        }
        this.fPattern = pattern;
        this.fPatternStatus.setOK();
    }

    public IAccessRule getRule() {
        Path filePattern = new Path(this.fPattern);
        int kind = this.fRuleKinds[this.fRuleKindCombo.getSelectionIndex()];
        return JavaScriptCore.newAccessRule((IPath)filePattern, kind);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.wst.jsdt.ui.access_rules_dialog_context");
    }

    private class TypeRulesAdapter
    implements IDialogFieldListener {
        private TypeRulesAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            AccessRuleEntryDialog.this.doStatusLineUpdate();
        }
    }
}

