/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeMethodSignatureProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.TypeChangeCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class TypeMismatchSubProcessor {
    private TypeMismatchSubProcessor() {
    }

    public static void addTypeMismatchProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        BodyDeclaration decl;
        boolean nullOrVoid;
        String[] args = problem.getProblemArguments();
        if (args.length != 2) {
            return;
        }
        IJavaScriptUnit cu = context.getCompilationUnit();
        JavaScriptUnit astRoot = context.getASTRoot();
        AST ast = astRoot.getAST();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (!(selectedNode instanceof Expression)) {
            return;
        }
        Expression nodeToCast = (Expression)selectedNode;
        Name receiverNode = null;
        ITypeBinding castTypeBinding = null;
        int parentNodeType = selectedNode.getParent().getNodeType();
        if (parentNodeType == 7) {
            Assignment assign = (Assignment)selectedNode.getParent();
            Expression leftHandSide = assign.getLeftHandSide();
            if (selectedNode.equals(leftHandSide)) {
                nodeToCast = assign.getRightHandSide();
            }
            castTypeBinding = assign.getLeftHandSide().resolveTypeBinding();
            if (leftHandSide instanceof Name) {
                receiverNode = (Name)leftHandSide;
            } else if (leftHandSide instanceof FieldAccess) {
                receiverNode = ((FieldAccess)leftHandSide).getName();
            }
        } else if (parentNodeType == 59) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)selectedNode.getParent();
            if (selectedNode.equals(frag.getName()) || selectedNode.equals(frag.getInitializer())) {
                nodeToCast = frag.getInitializer();
                castTypeBinding = ASTNodes.getType(frag).resolveBinding();
                receiverNode = frag.getName();
            }
        } else {
            castTypeBinding = ASTResolving.guessBindingForReference(nodeToCast);
        }
        if (castTypeBinding == null) {
            return;
        }
        ITypeBinding currBinding = nodeToCast.resolveTypeBinding();
        boolean bl = nullOrVoid = currBinding == null || "void".equals(currBinding.getName());
        if (!nullOrVoid && parentNodeType == 41 && (decl = ASTResolving.findParentBodyDeclaration(selectedNode)) instanceof FunctionDeclaration) {
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)decl;
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            ASTRewrite rewrite = ASTRewrite.create(ast);
            String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturntype_description, currBinding.getName());
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
            ImportRewrite imports = proposal.createImportRewrite(astRoot);
            Type newReturnType = imports.addImport(currBinding, ast);
            rewrite.replace(methodDeclaration.getReturnType2(), newReturnType, null);
            String returnKey = "return";
            proposal.addLinkedPosition(rewrite.track(newReturnType), true, returnKey);
            ITypeBinding[] typeSuggestions = ASTResolving.getRelaxingTypes(ast, currBinding);
            int i = 0;
            while (i < typeSuggestions.length) {
                proposal.addLinkedPositionProposal(returnKey, typeSuggestions[i]);
                ++i;
            }
            proposals.add(proposal);
        }
        if (!nullOrVoid && receiverNode != null) {
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, receiverNode, currBinding, true, 6, proposals);
        }
        TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, nodeToCast, castTypeBinding, false, 5, proposals);
    }

    public static void addChangeSenderTypeProposals(IInvocationContext context, Expression nodeToCast, ITypeBinding castTypeBinding, boolean isAssignedNode, int relevance, Collection proposals) throws JavaScriptModelException {
        IBinding methodBinding;
        IBinding callerBinding = null;
        switch (nodeToCast.getNodeType()) {
            case 32: {
                callerBinding = ((FunctionInvocation)nodeToCast).resolveMethodBinding();
                break;
            }
            case 48: {
                callerBinding = ((SuperMethodInvocation)nodeToCast).resolveMethodBinding();
                break;
            }
            case 22: {
                callerBinding = ((FieldAccess)nodeToCast).resolveFieldBinding();
                break;
            }
            case 47: {
                callerBinding = ((SuperFieldAccess)nodeToCast).resolveFieldBinding();
                break;
            }
            case 40: 
            case 42: {
                callerBinding = ((Name)nodeToCast).resolveBinding();
            }
        }
        IJavaScriptUnit cu = context.getCompilationUnit();
        JavaScriptUnit astRoot = context.getASTRoot();
        IJavaScriptUnit targetCu = null;
        ITypeBinding declaringType = null;
        IBinding callerBindingDecl = callerBinding;
        if (callerBinding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)callerBinding;
            if (!variableBinding.isField()) {
                targetCu = cu;
            } else {
                callerBindingDecl = variableBinding.getVariableDeclaration();
                ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                if (declaringClass == null) {
                    return;
                }
                declaringType = declaringClass.getTypeDeclaration();
            }
        } else if (callerBinding instanceof IFunctionBinding && !(methodBinding = callerBinding).isConstructor()) {
            declaringType = methodBinding.getDeclaringClass().getTypeDeclaration();
            callerBindingDecl = methodBinding.getMethodDeclaration();
        }
        if (declaringType != null && declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null && ASTResolving.isUseableTypeInContext(castTypeBinding, callerBindingDecl, false)) {
            proposals.add(new TypeChangeCompletionProposal(targetCu, callerBindingDecl, astRoot, castTypeBinding, isAssignedNode, relevance));
        }
    }

    public static void addIncompatibleReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws JavaScriptModelException {
        JavaScriptUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        FunctionDeclaration decl = ASTResolving.findParentMethodDeclaration(selectedNode);
        if (decl == null) {
            return;
        }
        IFunctionBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        IFunctionBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null || overridden.getReturnType() == methodDeclBinding.getReturnType()) {
            return;
        }
        IJavaScriptUnit cu = context.getCompilationUnit();
        IFunctionBinding methodDecl = methodDeclBinding.getMethodDeclaration();
        proposals.add(new TypeChangeCompletionProposal(cu, methodDecl, astRoot, overridden.getReturnType(), false, 8));
        IJavaScriptUnit targetCu = cu;
        IFunctionBinding overriddenDecl = overridden.getMethodDeclaration();
        ITypeBinding overridenDeclType = overriddenDecl.getDeclaringClass();
        ITypeBinding returnType = methodDeclBinding.getReturnType();
        if (overridenDeclType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, overridenDeclType);
        }
        if (targetCu != null && ASTResolving.isUseableTypeInContext(returnType, (IBinding)overriddenDecl, false)) {
            TypeChangeCompletionProposal proposal = new TypeChangeCompletionProposal(targetCu, overriddenDecl, astRoot, returnType, false, 7);
            proposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofoverridden_description, overriddenDecl.getName()));
            proposals.add(proposal);
        }
    }

    public static void addIncompatibleThrowsProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws JavaScriptModelException {
        JavaScriptUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof FunctionDeclaration)) {
            return;
        }
        FunctionDeclaration decl = (FunctionDeclaration)selectedNode;
        IFunctionBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        IFunctionBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null) {
            return;
        }
        IJavaScriptUnit cu = context.getCompilationUnit();
        ArrayList undeclaredExceptions = new ArrayList();
        ChangeMethodSignatureProposal.ChangeDescription[] changes = new ChangeMethodSignatureProposal.ChangeDescription[]{};
        String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_removeexceptions_description, methodDeclBinding.getName());
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.remove_correction.gif");
        proposals.add(new ChangeMethodSignatureProposal(label, cu, astRoot, methodDeclBinding, null, changes, 8, image));
        ITypeBinding declaringType = overridden.getDeclaringClass();
        IJavaScriptUnit targetCu = cu;
        if (declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null) {
            ChangeMethodSignatureProposal.ChangeDescription[] changes2 = new ChangeMethodSignatureProposal.ChangeDescription[undeclaredExceptions.size()];
            int i = 0;
            while (i < undeclaredExceptions.size()) {
                changes2[i] = new ChangeMethodSignatureProposal.InsertDescription((ITypeBinding)undeclaredExceptions.get(i), "");
                ++i;
            }
            IFunctionBinding overriddenDecl = overridden.getMethodDeclaration();
            Object[] args = new String[]{declaringType.getName(), overridden.getName()};
            String label2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addexceptions_description, args);
            Image image2 = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.add_correction.gif");
            proposals.add(new ChangeMethodSignatureProposal(label2, targetCu, astRoot, overriddenDecl, null, changes2, 7, image2));
        }
    }
}

