/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.MissingReturnTypeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ReplaceCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.TypeMismatchSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ReturnTypeSubProcessor {
    public static void addMethodWithConstrNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IJavaScriptUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof FunctionDeclaration) {
            FunctionDeclaration declaration = (FunctionDeclaration)selectedNode;
            ASTRewrite rewrite = ASTRewrite.create(declaration.getAST());
            rewrite.set(declaration, FunctionDeclaration.CONSTRUCTOR_PROPERTY, Boolean.TRUE, null);
            String label = CorrectionMessages.ReturnTypeSubProcessor_constrnamemethod_description;
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal);
        }
    }

    public static void addVoidMethodReturnsProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        IJavaScriptUnit cu = context.getCompilationUnit();
        JavaScriptUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof FunctionDeclaration && selectedNode.getNodeType() == 41) {
            ReturnStatement returnStatement = (ReturnStatement)selectedNode;
            Expression expr = returnStatement.getExpression();
            if (expr != null) {
                AST ast = astRoot.getAST();
                ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                if (binding == null) {
                    binding = ast.resolveWellKnownType("java.lang.Object");
                }
                FunctionDeclaration methodDeclaration = (FunctionDeclaration)decl;
                ASTRewrite rewrite = ASTRewrite.create(ast);
                String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_voidmethodreturns_description, BindingLabelProvider.getBindingLabel(binding, 0x20000AL));
                Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
                LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
                ImportRewrite imports = proposal.createImportRewrite(astRoot);
                Type newReturnType = imports.addImport(binding, ast);
                if (methodDeclaration.isConstructor()) {
                    rewrite.set(methodDeclaration, FunctionDeclaration.CONSTRUCTOR_PROPERTY, Boolean.FALSE, null);
                    rewrite.set(methodDeclaration, FunctionDeclaration.RETURN_TYPE2_PROPERTY, newReturnType, null);
                } else {
                    rewrite.replace(methodDeclaration.getReturnType2(), newReturnType, null);
                }
                String key = "return_type";
                proposal.addLinkedPosition(rewrite.track(newReturnType), true, key);
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(ast, binding);
                int i = 0;
                while (i < bindings.length) {
                    proposal.addLinkedPositionProposal(key, bindings[i]);
                    ++i;
                }
                JSdoc javadoc = methodDeclaration.getJavadoc();
                if (javadoc != null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@return");
                    TextElement commentStart = ast.newTextElement();
                    newTag.fragments().add(commentStart);
                    JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite(javadoc, JSdoc.TAGS_PROPERTY), newTag, null);
                    proposal.addLinkedPosition(rewrite.track(commentStart), false, "comment_start");
                }
                proposals.add(proposal);
            }
            ASTRewrite rewrite = ASTRewrite.create(decl.getAST());
            rewrite.remove(returnStatement.getExpression(), null);
            String label = CorrectionMessages.ReturnTypeSubProcessor_removereturn_description;
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal);
        }
    }

    public static void addMissingReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        IJavaScriptUnit cu = context.getCompilationUnit();
        JavaScriptUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof FunctionDeclaration) {
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)decl;
            ReturnStatementCollector eval = new ReturnStatementCollector();
            decl.accept(eval);
            AST ast = astRoot.getAST();
            ITypeBinding typeBinding = eval.getTypeBinding(decl.getAST());
            typeBinding = Bindings.normalizeTypeBinding(typeBinding);
            if (typeBinding == null) {
                typeBinding = ast.resolveWellKnownType("void");
            }
            ASTRewrite rewrite = ASTRewrite.create(ast);
            String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_missingreturntype_description, BindingLabelProvider.getBindingLabel(typeBinding, 0x20000AL));
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
            ImportRewrite imports = proposal.createImportRewrite(astRoot);
            Type type = imports.addImport(typeBinding, ast);
            rewrite.set(methodDeclaration, FunctionDeclaration.RETURN_TYPE2_PROPERTY, type, null);
            rewrite.set(methodDeclaration, FunctionDeclaration.CONSTRUCTOR_PROPERTY, Boolean.FALSE, null);
            JSdoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null && typeBinding != null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@return");
                TextElement commentStart = ast.newTextElement();
                newTag.fragments().add(commentStart);
                JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite(javadoc, JSdoc.TAGS_PROPERTY), newTag, null);
                proposal.addLinkedPosition(rewrite.track(commentStart), false, "comment_start");
            }
            String key = "return_type";
            proposal.addLinkedPosition(rewrite.track(type), true, key);
            if (typeBinding != null) {
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(ast, typeBinding);
                int i = 0;
                while (i < bindings.length) {
                    proposal.addLinkedPositionProposal(key, bindings[i]);
                    ++i;
                }
            }
            proposals.add(proposal);
            ASTNode parentType = ASTResolving.findParentType(decl);
            if (parentType instanceof AbstractTypeDeclaration) {
                String constructorName = ((TypeDeclaration)parentType).getName().getIdentifier();
                SimpleName nameNode = methodDeclaration.getName();
                label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_wrongconstructorname_description, constructorName);
                proposals.add(new ReplaceCorrectionProposal(label, cu, nameNode.getStartPosition(), nameNode.getLength(), constructorName, 5));
            }
        }
    }

    public static void addMissingReturnStatementProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IJavaScriptUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof FunctionDeclaration) {
            FunctionDeclaration methodDecl = (FunctionDeclaration)decl;
            Block block = methodDecl.getBody();
            if (block == null) {
                return;
            }
            ReturnStatement existingStatement = selectedNode instanceof ReturnStatement ? (ReturnStatement)selectedNode : null;
            proposals.add(new MissingReturnTypeCorrectionProposal(cu, methodDecl, existingStatement, 6));
            Type returnType = methodDecl.getReturnType2();
            if (returnType != null && !"void".equals(ASTNodes.asString(returnType))) {
                TagElement tagElement;
                AST ast = methodDecl.getAST();
                ASTRewrite rewrite = ASTRewrite.create(ast);
                rewrite.replace(returnType, ast.newPrimitiveType(PrimitiveType.VOID), null);
                JSdoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null && (tagElement = JavadocTagsSubProcessor.findTag(javadoc, "@return", null)) != null) {
                    rewrite.remove(tagElement, null);
                }
                String label = CorrectionMessages.ReturnTypeSubProcessor_changetovoid_description;
                Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
                proposals.add(proposal);
            }
        }
    }

    public static void addMethodRetunsVoidProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws JavaScriptModelException {
        JavaScriptUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof ReturnStatement)) {
            return;
        }
        ReturnStatement returnStatement = (ReturnStatement)selectedNode;
        Expression expression = returnStatement.getExpression();
        if (expression == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof FunctionDeclaration) {
            FunctionDeclaration methDecl = (FunctionDeclaration)decl;
            Type retType = methDecl.getReturnType2();
            if (retType == null || retType.resolveBinding() == null) {
                return;
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, expression, retType.resolveBinding(), false, 4, proposals);
        }
    }

    private static class ReturnStatementCollector
    extends ASTVisitor {
        private ArrayList fResult = new ArrayList();

        private ReturnStatementCollector() {
        }

        public Iterator returnStatements() {
            return this.fResult.iterator();
        }

        public ITypeBinding getTypeBinding(AST ast) {
            boolean couldBeObject = false;
            int i = 0;
            while (i < this.fResult.size()) {
                ReturnStatement node = (ReturnStatement)this.fResult.get(i);
                Expression expr = node.getExpression();
                if (expr != null) {
                    ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                    if (binding != null) {
                        return binding;
                    }
                } else {
                    return ast.resolveWellKnownType("void");
                }
                couldBeObject = true;
                ++i;
            }
            if (couldBeObject) {
                return ast.resolveWellKnownType("java.lang.Object");
            }
            return ast.resolveWellKnownType("void");
        }

        @Override
        public boolean visit(ReturnStatement node) {
            this.fResult.add(node);
            return false;
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(TypeDeclaration node) {
            return false;
        }
    }
}

