/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementLine;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class ImplementOccurrencesFinder
implements IOccurrencesFinder {
    private ASTNode fStart;
    private List fResult = new ArrayList();
    private ASTNode fSelectedNode;
    private ITypeBinding fSelectedType;

    @Override
    public String initialize(JavaScriptUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform(root, offset, length));
    }

    public String initialize(JavaScriptUnit root, ASTNode node) {
        if (!(node instanceof Name)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedNode = ASTNodes.getNormalizedNode(node);
        if (!(this.fSelectedNode instanceof Type)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        ASTNode typeDeclaration = this.fSelectedNode.getParent();
        if (!(typeDeclaration instanceof AbstractTypeDeclaration)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedType = ((Type)this.fSelectedNode).resolveBinding();
        if (this.fSelectedType == null) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fStart = typeDeclaration;
        return null;
    }

    @Override
    public List perform() {
        this.fStart.accept(new MethodVisitor());
        if (this.fSelectedNode != null) {
            this.fResult.add(this.fSelectedNode);
        }
        return this.fResult;
    }

    @Override
    public void collectOccurrenceMatches(IJavaScriptElement element, IDocument document, Collection resultingMatches) {
        for (ASTNode node : this.fResult) {
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            try {
                int line = document.getLineOfOffset(startPosition);
                IRegion region = document.getLineInformation(line);
                String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                JavaElementLine groupKey = new JavaElementLine(element, line, lineContents);
                resultingMatches.add(new Match((Object)groupKey, startPosition, length));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.ImplementOccurrencesFinder_searchfor;
    }

    @Override
    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString(this.fSelectedNode);
        }
        return null;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.ImplementOccurrencesFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.ImplementOccurrencesFinder_label_singular;
    }

    public void releaseAST() {
        this.fStart = null;
        this.fSelectedType = null;
    }

    private class MethodVisitor
    extends ASTVisitor {
        private MethodVisitor() {
        }

        @Override
        public boolean visit(FunctionDeclaration node) {
            IFunctionBinding method;
            IFunctionBinding binding = node.resolveBinding();
            if (binding != null && (method = Bindings.findOverriddenMethodInHierarchy(ImplementOccurrencesFinder.this.fSelectedType, binding)) != null) {
                ImplementOccurrencesFinder.this.fResult.add(node.getName());
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(TypeDeclarationStatement node) {
            return false;
        }
    }
}

