/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.Logger;
import org.eclipse.wst.jsdt.internal.ui.preferences.InstalledJSRuntimesBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;

public class JSRuntimesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.wst.jsdt.ui.preferences.RuntimesPreferencePage";
    private String[] runtimeNamesArray;
    private String[] runtimeIndexToIdsMap;
    private Map<String, IJSRuntimeInstall> defaultInstallByType;
    private Map<String, IJSRuntimeInstall[]> fRuntimeInstallsByType;
    private Map<String, String> fOriginalRuntimesTimeStamp;
    private Map<String, String> fLastRuntimesTimeStamp;
    private String currentRuntimeTypeId;
    private Combo fJSTypeCombo;
    private InstalledJSRuntimesBlock fJSRuntimesBlock;

    public void init(IWorkbench workbench) {
        this.defaultInstallByType = new HashMap<String, IJSRuntimeInstall>();
        this.fRuntimeInstallsByType = new HashMap<String, IJSRuntimeInstall[]>();
        this.fOriginalRuntimesTimeStamp = new HashMap<String, String>();
        this.fLastRuntimesTimeStamp = new HashMap<String, String>();
    }

    private void initRuntimeTypes() {
        if (this.runtimeNamesArray == null) {
            Collection<IJSRuntimeType> runtimeTypes = JSRuntimeManager.getJSRuntimeTypes();
            IJSRuntimeType[] jsRuntimeTypes = new IJSRuntimeType[runtimeTypes.size()];
            runtimeTypes.toArray(jsRuntimeTypes);
            Arrays.sort(jsRuntimeTypes, new Comparator<IJSRuntimeType>(){

                @Override
                public int compare(IJSRuntimeType runtime1, IJSRuntimeType runtime2) {
                    return runtime1.getName().compareToIgnoreCase(runtime2.getName());
                }
            });
            this.runtimeIndexToIdsMap = new String[jsRuntimeTypes.length];
            this.runtimeNamesArray = new String[jsRuntimeTypes.length];
            int i = 0;
            while (i < jsRuntimeTypes.length) {
                this.runtimeNamesArray[i] = jsRuntimeTypes[i].getName();
                this.runtimeIndexToIdsMap[i] = jsRuntimeTypes[i].getId();
                ++i;
            }
        }
    }

    private void initDefaultRuntimeInstallsMap() {
        this.defaultInstallByType.clear();
        Collection<String> runtimeTypeIds = JSRuntimeManager.getJSRuntimeTypesIds();
        for (String runtimeTypeId : runtimeTypeIds) {
            IJSRuntimeInstall runtimeInstall = JSRuntimeManager.getDefaultRuntimeInstall(runtimeTypeId);
            this.defaultInstallByType.put(runtimeTypeId, runtimeInstall);
        }
    }

    private void initRuntimeInstallsByTypeMap() {
        this.fRuntimeInstallsByType.clear();
        Collection<String> runtimeTypeIds = JSRuntimeManager.getJSRuntimeTypesIds();
        for (String runtimeTypeId : runtimeTypeIds) {
            IJSRuntimeInstall[] runtimeInstalls = JSRuntimeManager.getJSRuntimeInstallsByType(runtimeTypeId);
            this.fRuntimeInstallsByType.put(runtimeTypeId, runtimeInstalls);
        }
    }

    private String getRuntimeTypeId(int selection) {
        if (selection >= 0 && selection < this.runtimeIndexToIdsMap.length) {
            return this.runtimeIndexToIdsMap[selection];
        }
        return null;
    }

    private void backupTimeStamp() {
        String oldTimeStamp = this.fOriginalRuntimesTimeStamp.get(this.currentRuntimeTypeId);
        if (oldTimeStamp == null) {
            this.fOriginalRuntimesTimeStamp.put(this.currentRuntimeTypeId, this.fJSRuntimesBlock.getTimeStamp());
        }
        this.fLastRuntimesTimeStamp.put(this.currentRuntimeTypeId, this.fJSRuntimesBlock.getTimeStamp());
    }

    private void clearEnvironment() {
        this.initRuntimeInstallsByTypeMap();
        this.initDefaultRuntimeInstallsMap();
        this.fOriginalRuntimesTimeStamp.clear();
        this.fLastRuntimesTimeStamp.clear();
        this.currentRuntimeTypeId = this.getRuntimeTypeId(0);
        if (this.currentRuntimeTypeId != null) {
            this.fJSTypeCombo.select(0);
            this.fJSRuntimesBlock.setRuntimeType(JSRuntimeManager.getJSRuntimeType(this.currentRuntimeTypeId));
            this.initDefaultRuntime();
        }
        this.backupTimeStamp();
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        SWTFactory.createWrapLabel((Composite)ancestor, (String)PreferencesMessages.JSRuntimesPreferencePage_JSRuntimes_Title, (int)1, (int)300);
        SWTFactory.createVerticalSpacer((Composite)ancestor, (int)1);
        this.initRuntimeTypes();
        this.fJSTypeCombo = SWTFactory.createCombo((Composite)ancestor, (int)2056, (int)1, (String[])this.runtimeNamesArray);
        this.fJSTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSRuntimesPreferencePage.this.fRuntimeInstallsByType.put(JSRuntimesPreferencePage.this.currentRuntimeTypeId, JSRuntimesPreferencePage.this.fJSRuntimesBlock.getRuntimeInstalls());
                JSRuntimesPreferencePage.this.backupTimeStamp();
                JSRuntimesPreferencePage.this.currentRuntimeTypeId = JSRuntimesPreferencePage.this.getRuntimeTypeId(JSRuntimesPreferencePage.this.fJSTypeCombo.getSelectionIndex());
                JSRuntimesPreferencePage.this.fJSRuntimesBlock.setRuntimeType(JSRuntimeManager.getJSRuntimeType(JSRuntimesPreferencePage.this.currentRuntimeTypeId), (IJSRuntimeInstall[])JSRuntimesPreferencePage.this.fRuntimeInstallsByType.get(JSRuntimesPreferencePage.this.currentRuntimeTypeId));
                JSRuntimesPreferencePage.this.updateDefaultRuntimeInstall((IJSRuntimeInstall)JSRuntimesPreferencePage.this.defaultInstallByType.get(JSRuntimesPreferencePage.this.currentRuntimeTypeId));
                JSRuntimesPreferencePage.this.backupTimeStamp();
                super.widgetSelected(e);
            }
        });
        this.fJSRuntimesBlock = new InstalledJSRuntimesBlock();
        this.fJSRuntimesBlock.createControl(ancestor);
        Control control = this.fJSRuntimesBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fJSRuntimesBlock.restoreColumnSettings(JavaScriptPlugin.getDefault().getDialogSettings(), ID);
        this.fJSRuntimesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IJSRuntimeInstall install = JSRuntimesPreferencePage.this.fJSRuntimesBlock.getCheckedRuntimeInstall();
                if (install == null) {
                    JSRuntimesPreferencePage.this.setValid(false);
                    if (JSRuntimesPreferencePage.this.fJSRuntimesBlock.getRuntimeInstalls().length < 1) {
                        JSRuntimesPreferencePage.this.setErrorMessage(PreferencesMessages.JSRuntimesPreferencePage_NoRuntimes_Error);
                    } else {
                        JSRuntimesPreferencePage.this.setErrorMessage(PreferencesMessages.JSRuntimesPreferencePage_NoDefaultRuntime_Error);
                    }
                } else {
                    JSRuntimesPreferencePage.this.setMessage(null);
                    JSRuntimesPreferencePage.this.setValid(true);
                    JSRuntimesPreferencePage.this.setErrorMessage(null);
                    JSRuntimesPreferencePage.this.updateDefaultRuntimeInstall(install);
                }
            }
        });
        this.applyDialogFont(ancestor);
        this.clearEnvironment();
        return ancestor;
    }

    private void initDefaultRuntime() {
        IJSRuntimeInstall realDefault = JSRuntimeManager.getDefaultRuntimeInstall(this.currentRuntimeTypeId);
        if (realDefault != null) {
            IJSRuntimeInstall[] vms = this.fJSRuntimesBlock.getRuntimeInstalls();
            int i = 0;
            while (i < vms.length) {
                IJSRuntimeInstall fakeRuntime = vms[i];
                if (fakeRuntime.equals(realDefault)) {
                    this.fJSRuntimesBlock.setCheckedRuntimeInstall(fakeRuntime);
                    break;
                }
                ++i;
            }
        }
    }

    private void updateDefaultRuntimeInstall(IJSRuntimeInstall install) {
        if (this.currentRuntimeTypeId != null) {
            this.defaultInstallByType.put(this.currentRuntimeTypeId, install);
            this.fJSRuntimesBlock.setCheckedRuntimeInstall(install);
        }
    }

    public boolean performOk() {
        boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                JSRuntimesPreferencePage.this.fRuntimeInstallsByType.put(JSRuntimesPreferencePage.this.currentRuntimeTypeId, JSRuntimesPreferencePage.this.fJSRuntimesBlock.getRuntimeInstalls());
                Set runtimeTypesIds = JSRuntimesPreferencePage.this.fRuntimeInstallsByType.keySet();
                for (String runtimeTypeId : runtimeTypesIds) {
                    IJSRuntimeInstall[] currentInstalls = (IJSRuntimeInstall[])JSRuntimesPreferencePage.this.fRuntimeInstallsByType.get(runtimeTypeId);
                    ArrayList<String> currentInstallIds = new ArrayList<String>();
                    int i = 0;
                    while (i < currentInstalls.length) {
                        if (currentInstalls[i] instanceof JSRuntimeWorkingCopy) {
                            JSRuntimeWorkingCopy standin = (JSRuntimeWorkingCopy)currentInstalls[i];
                            standin.convertToRealRuntime();
                        }
                        currentInstallIds.add(currentInstalls[i].getId());
                        ++i;
                    }
                    IJSRuntimeInstall[] allInstalls = JSRuntimeManager.getJSRuntimeInstallsByType(runtimeTypeId);
                    int i2 = 0;
                    while (i2 < allInstalls.length) {
                        if (!currentInstallIds.contains(allInstalls[i2].getId())) {
                            JSRuntimeManager.removeJSRuntimeInstall(allInstalls[i2].getId());
                        }
                        ++i2;
                    }
                    IJSRuntimeInstall defaultInstall = (IJSRuntimeInstall)JSRuntimesPreferencePage.this.defaultInstallByType.get(runtimeTypeId);
                    if (defaultInstall == null) continue;
                    JSRuntimeManager.setDefaultRuntimeInstall(runtimeTypeId, defaultInstall.getId());
                }
                JSRuntimesPreferencePage.this.fOriginalRuntimesTimeStamp.clear();
                JSRuntimesPreferencePage.this.fLastRuntimesTimeStamp.clear();
                try {
                    JSRuntimeManager.saveRuntimesConfiguration();
                }
                catch (CoreException e) {
                    Logger.log(4, "Error saving preferences for JavaScript runtimes.", e);
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        IDialogSettings settings = JavaScriptPlugin.getDefault().getDialogSettings();
        this.fJSRuntimesBlock.saveColumnSettings(settings, ID);
        return super.performOk();
    }

    public boolean okToLeave() {
        this.backupTimeStamp();
        boolean hasChanges = false;
        Set<String> keys = this.fOriginalRuntimesTimeStamp.keySet();
        for (String key : keys) {
            String finalts;
            String originalts = this.fOriginalRuntimesTimeStamp.get(key);
            if (originalts.equals(finalts = this.fLastRuntimesTimeStamp.get(key))) continue;
            hasChanges = true;
            break;
        }
        if (hasChanges) {
            String title = PreferencesMessages.JSRuntimesPreferencePage_JSRuntimes_Title;
            String message = PreferencesMessages.JSRuntimesPreferencePage_UnsavedChanges_Message;
            String[] buttonLabels = new String[]{PreferencesMessages.JSRuntimesPreferencePage_ApplyButton_Label, PreferencesMessages.JSRuntimesPreferencePage_DiscardButton_Label, PreferencesMessages.JSRuntimesPreferencePage_ApplyLaterButton_Label};
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
            int res = dialog.open();
            if (res == 0) {
                return this.performOk() && super.okToLeave();
            }
            if (res == 1) {
                this.clearEnvironment();
                this.fJSRuntimesBlock.restoreColumnSettings(JavaScriptPlugin.getDefault().getDialogSettings(), ID);
            }
        }
        return super.okToLeave();
    }
}

