/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class CodeRefactoringUtil {
    public static RefactoringStatus checkMethodSyntaxErrors(int selectionStart, int selectionLength, JavaScriptUnit cuNode, String invalidSelectionMessage) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(selectionStart, selectionLength), true);
        cuNode.accept(analyzer);
        ASTNode coveringNode = analyzer.getLastCoveringNode();
        if (!(coveringNode instanceof Block) || !(coveringNode.getParent() instanceof FunctionDeclaration)) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        if (ASTNodes.getMessages(coveringNode, 0).length == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        FunctionDeclaration methodDecl = (FunctionDeclaration)coveringNode.getParent();
        Object[] keys = new String[]{methodDecl.getName().getIdentifier()};
        String message = Messages.format(RefactoringCoreMessages.CodeRefactoringUtil_error_message, keys);
        return RefactoringStatus.createFatalErrorStatus((String)message);
    }

    public static int getIndentationLevel(ASTNode node, IJavaScriptUnit unit) throws CoreException {
        IPath fullPath = unit.getCorrespondingResource().getFullPath();
        try {
            FileBuffers.getTextFileBufferManager().connect(fullPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(fullPath, LocationKind.IFILE);
            try {
                IRegion region = buffer.getDocument().getLineInformationOfOffset(node.getStartPosition());
                int n = Strings.computeIndentUnits(buffer.getDocument().get(region.getOffset(), region.getLength()), unit.getJavaScriptProject());
                return n;
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
                FileBuffers.getTextFileBufferManager().disconnect(fullPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                return 0;
            }
        }
        finally {
            FileBuffers.getTextFileBufferManager().disconnect(fullPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private CodeRefactoringUtil() {
    }
}

