/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameJavaProjectChange
extends AbstractJavaElementRenameChange {
    private boolean fUpdateReferences;

    public RenameJavaProjectChange(IJavaScriptProject project, String newName, boolean updateReferences) {
        this(project.getPath(), project.getElementName(), newName, -1L, updateReferences);
        Assert.isTrue((!project.isReadOnly() ? 1 : 0) != 0, (String)"should not be read only");
    }

    private RenameJavaProjectChange(IPath resourcePath, String oldName, String newName, long stampToRestore, boolean updateReferences) {
        super(resourcePath, oldName, newName);
        this.fUpdateReferences = updateReferences;
    }

    private IIncludePathEntry createModifiedEntry(IIncludePathEntry oldEntry) {
        return JavaScriptCore.newProjectEntry(this.createNewPath(), oldEntry.getAccessRules(), oldEntry.combineAccessRules(), oldEntry.getExtraAttributes(), oldEntry.isExported());
    }

    @Override
    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    @Override
    protected Change createUndoChange(long stampToRestore) throws JavaScriptModelException {
        return new RenameJavaProjectChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore, this.fUpdateReferences);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        try {
            IProject project;
            pm.beginTask(this.getName(), 2);
            if (this.fUpdateReferences) {
                this.modifyClassPaths((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            if ((project = this.getProject()) != null) {
                IProjectDescription description = project.getDescription();
                description.setName(this.getNewName());
                project.move(description, 33, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    private IJavaScriptProject getJavaProject() {
        return (IJavaScriptProject)this.getModifiedElement();
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_rename, new String[]{this.getOldName(), this.getNewName()});
    }

    private IProject getProject() {
        IJavaScriptProject jp = this.getJavaProject();
        if (jp == null) {
            return null;
        }
        return jp.getProject();
    }

    private boolean isOurEntry(IIncludePathEntry cpe) {
        if (cpe.getEntryKind() != 2) {
            return false;
        }
        return cpe.getPath().equals((Object)this.getResourcePath());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 2);
    }

    private void modifyClassPath(IJavaScriptProject referencingProject, IProgressMonitor pm) throws JavaScriptModelException {
        pm.beginTask("", 1);
        IIncludePathEntry[] oldEntries = referencingProject.getRawIncludepath();
        IIncludePathEntry[] newEntries = new IIncludePathEntry[oldEntries.length];
        int i = 0;
        while (i < newEntries.length) {
            newEntries[i] = this.isOurEntry(oldEntries[i]) ? this.createModifiedEntry(oldEntries[i]) : oldEntries[i];
            ++i;
        }
        referencingProject.setRawIncludepath(newEntries, pm);
        pm.done();
    }

    private void modifyClassPaths(IProgressMonitor pm) throws JavaScriptModelException {
        IProject[] referencing = this.getProject().getReferencingProjects();
        pm.beginTask(RefactoringCoreMessages.RenameJavaProjectChange_update, referencing.length);
        int i = 0;
        while (i < referencing.length) {
            IJavaScriptProject jp = JavaScriptCore.create(referencing[i]);
            if (jp != null && jp.exists()) {
                this.modifyClassPath(jp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            } else {
                pm.worked(1);
            }
            ++i;
        }
        pm.done();
    }
}

