/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.WorkspaceTracker;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class DynamicValidationStateChange
extends CompositeChange
implements WorkspaceTracker.Listener {
    private boolean fListenerRegistered = false;
    private RefactoringStatus fValidationState = null;
    private long fTimeStamp;
    private ISchedulingRule fSchedulingRule;
    private static final long LIFE_TIME = 1800000L;

    public DynamicValidationStateChange(Change change) {
        super(change.getName());
        this.add(change);
        this.markAsSynthetic();
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public DynamicValidationStateChange(String name) {
        super(name);
        this.markAsSynthetic();
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public DynamicValidationStateChange(String name, Change[] changes) {
        super(name, changes);
        this.markAsSynthetic();
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void initializeValidationData(IProgressMonitor pm) {
        super.initializeValidationData(pm);
        WorkspaceTracker.INSTANCE.addListener(this);
        this.fListenerRegistered = true;
        this.fTimeStamp = System.currentTimeMillis();
    }

    public void dispose() {
        if (this.fListenerRegistered) {
            WorkspaceTracker.INSTANCE.removeListener(this);
            this.fListenerRegistered = false;
        }
        super.dispose();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fValidationState == null) {
            return super.isValid(pm);
        }
        return this.fValidationState;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        final Change[] result = new Change[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                result[0] = DynamicValidationStateChange.super.perform(monitor);
            }
        };
        JavaScriptCore.run(runnable, this.fSchedulingRule, pm);
        return result[0];
    }

    protected Change createUndoChange(Change[] childUndos) {
        DynamicValidationStateChange result = new DynamicValidationStateChange(this.getName());
        int i = 0;
        while (i < childUndos.length) {
            result.add(childUndos[i]);
            ++i;
        }
        return result;
    }

    @Override
    public void workspaceChanged() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.fTimeStamp < 1800000L) {
            return;
        }
        this.fValidationState = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.DynamicValidationStateChange_workspace_changed);
        WorkspaceTracker.INSTANCE.removeListener(this);
        this.fListenerRegistered = false;
        Change[] children = this.clear();
        int i = 0;
        while (i < children.length) {
            final Change change = children[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    change.dispose();
                }

                public void handleException(Throwable exception) {
                    JavaScriptPlugin.log(exception);
                }
            });
            ++i;
        }
    }

    public void setSchedulingRule(ISchedulingRule schedulingRule) {
        this.fSchedulingRule = schedulingRule;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fSchedulingRule;
    }
}

