/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;

class Util {
    Util() {
    }

    static boolean rangeIncludesNonWhitespaceOutsideRange(SourceRange selection, SourceRange nodes, IBuffer buffer) {
        if (!selection.covers(nodes)) {
            return false;
        }
        if (!Util.isJustWhitespace(selection.getOffset(), nodes.getOffset(), buffer)) {
            return true;
        }
        return !Util.isJustWhitespaceOrComment(nodes.getOffset() + nodes.getLength(), selection.getOffset() + selection.getLength(), buffer);
    }

    private static boolean isJustWhitespace(int start, int end, IBuffer buffer) {
        if (start == end) {
            return true;
        }
        Assert.isTrue((start <= end ? 1 : 0) != 0);
        return buffer.getText(start, end - start).trim().length() == 0;
    }

    private static boolean isJustWhitespaceOrComment(int start, int end, IBuffer buffer) {
        if (start == end) {
            return true;
        }
        Assert.isTrue((start <= end ? 1 : 0) != 0);
        String trimmedText = buffer.getText(start, end - start).trim();
        if (trimmedText.length() == 0) {
            return true;
        }
        IScanner scanner = ToolFactory.createScanner(false, false, false, null);
        scanner.setSource(trimmedText.toCharArray());
        try {
            return scanner.getNextToken() == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }
}

